/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.OperativeSys;

public final class JavaVM {
    public static String osName() {
        String os = System.getProperty("os.name", "unknown");
        return os.substring(0, 1).toUpperCase() + os.substring(1).toLowerCase();
    }

    public static OperativeSys getSystem() {
        String name = JavaVM.osName().toLowerCase();
        if (name.contains("win")) {
            return OperativeSys.WINDOWS;
        }
        if (name.contains("mac") || name.contains("darwin")) {
            return OperativeSys.MAC;
        }
        if (name.contains("nux")) {
            return OperativeSys.LINUX;
        }
        return OperativeSys.OTHER;
    }

    public static String osVersion() {
        return System.getProperty("os.version", "unknown");
    }

    public static String osModel() {
        return System.getProperty("sun.arch.data.model", "unknown");
    }

    public static String osArchitecture() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        String lastTry = System.getProperty("sun.cpu.isalist", "unknown");
        return arch != null ? arch : (wow64Arch != null ? wow64Arch : (lastTry != null ? lastTry : JavaVM.jvmArchitecture()));
    }

    public static String osMaxMemory() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            long max = Long.parseLong(attribute.toString());
            return (int)(max / 1024L / 1024L / 1024L + 1L) + "GB";
        }
        catch (Throwable ex) {
            return "unable to allocate memory";
        }
    }

    public static String osFreeMemory() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "FreePhysicalMemorySize");
            long available = Long.parseLong(attribute.toString());
            return (int)(available / 1024L / 1024L / 1024L + 1L) + "GB";
        }
        catch (Throwable ex) {
            return "unable to allocate memory";
        }
    }

    public static String jvmArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String jvmMax() {
        return Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB";
    }

    public static String jvmAvailable() {
        return Runtime.getRuntime().freeMemory() / 1024L / 1024L + " MB";
    }

    public static int jvmProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int javaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }
}

