/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.APISource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.KarmaConfig;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader.BruteLoader;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.loader.component.NameComponent;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.url.URLUtils;

public interface KarmaAPI
extends Serializable {
    public static String getVersion() {
        String version = "-1";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                version = properties.getProperty("version", "-1");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getCompilerVersion() {
        String version = "16";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                version = properties.getProperty("java_version", "15");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getBuildDate() {
        String compile_date = "01-01-1999 00:00:00";
        try {
            InputStream in = KarmaAPI.class.getResourceAsStream("/api.properties");
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                compile_date = properties.getProperty("compile_date", "01-01-1999 00:00:00");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return compile_date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLoaded(KarmaSource source) {
        boolean status = false;
        Path destJar = null;
        try {
            Path sourceJar22 = source.getSourceFile().toPath();
            destJar = Files.createTempFile(StringUtils.generateString().create() + "_", StringUtils.generateString().create(), new FileAttribute[0]);
            Files.move(sourceJar22, destJar, new CopyOption[0]);
            Files.move(destJar, sourceJar22, new CopyOption[0]);
            if (destJar == null) return status;
        }
        catch (Throwable ex) {
            try {
                status = true;
                return status;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (destJar != null) {
                    try {
                        Files.deleteIfExists(destJar);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            Files.deleteIfExists(destJar);
            return status;
        }
        catch (Throwable sourceJar22) {
            return status;
        }
    }

    public static KarmaSource source(boolean force) {
        return APISource.getOriginal(force);
    }

    public static void install() {
        BruteLoader loader;
        KarmaConfig config;
        block18: {
            config = new KarmaConfig();
            loader = null;
            try {
                loader = new BruteLoader((URLClassLoader)KarmaAPI.source(false).getClass().getClassLoader());
            }
            catch (Throwable ex) {
                try {
                    loader = new BruteLoader((URLClassLoader)Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable exc) {
                    if (!config.debug(Level.GRAVE)) break block18;
                    KarmaAPI.source(false).console().send((CharSequence)"Failed to install KarmaAPI dependencies because of {0}", Level.GRAVE, ex.fillInStackTrace());
                    for (StackTraceElement element : ex.getStackTrace()) {
                        KarmaAPI.source(false).console().send((CharSequence)"&c             {0}", element);
                    }
                }
            }
        }
        if (loader != null) {
            try {
                Class.forName("ml.karmaconfigs.remote.messaging.google.gson.Gson");
                Class.forName("ml.karmaconfigs.remote.messaging.google.gson.GsonBuilder").getMethod("setLenient", new Class[0]);
            }
            catch (Throwable ex) {
                if (config.debug(Level.WARNING)) {
                    KarmaAPI.source(false).console().send((CharSequence)"Google GSON dependency not found ( or very old version of it is running ) for UUID utilities, downloading it...", Level.WARNING);
                }
                loader.downloadAndInject(URLUtils.getOrNull("https://github.com/KarmaConfigs/updates/raw/master/KarmaAPI/GoogleGSON.jar"), NameComponent.forFile("GoogleGSON", "jar", new String[0]));
            }
            try {
                Class.forName("org.apache.http.HttpRequest");
            }
            catch (Throwable ex) {
                if (config.debug(Level.WARNING)) {
                    KarmaAPI.source(false).console().send((CharSequence)"Apache HTTP Core Components not found for URL utilities, downloading it...", Level.WARNING);
                }
                loader.downloadAndInject(URLUtils.getOrNull("https://github.com/KarmaConfigs/updates/raw/master/KarmaAPI/ApacheHTTPCore.jar"), NameComponent.forFile("ApacheHTTPCore", "jar", new String[0]));
            }
            try {
                Class.forName("org.apache.http.impl.client.HttpClients");
            }
            catch (Throwable ex) {
                if (config.debug(Level.WARNING)) {
                    KarmaAPI.source(false).console().send((CharSequence)"Apache HTTP Client Components not found for URL utilities, downloading it...", Level.WARNING);
                }
                loader.downloadAndInject(URLUtils.getOrNull("https://github.com/KarmaConfigs/updates/raw/master/KarmaAPI/ApacheHTTPClient.jar"), NameComponent.forFile("ApacheHTTPClient", "jar", new String[0]));
            }
            try {
                Class.forName("org.apache.commons.logging.LogFactory");
            }
            catch (Throwable ex) {
                if (config.debug(Level.WARNING)) {
                    KarmaAPI.source(false).console().send((CharSequence)"Apache Commons Logging not found for other utilities, downloading it...", Level.WARNING);
                }
                loader.downloadAndInject(URLUtils.getOrNull("https://repo1.maven.org/maven2/commons-logging/commons-logging/1.2/commons-logging-1.2.jar"), NameComponent.forFile("ApacheLogging", "jar", new String[0]));
            }
        }
    }
}

