/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.timer.worker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.timer.scheduler.Scheduler;

public class AsyncScheduler<T extends KarmaSource>
extends Scheduler {
    private static final Map<KarmaSource, Consumer<Integer>> taskStart = new HashMap<KarmaSource, Consumer<Integer>>();
    private static final Map<KarmaSource, Consumer<Integer>> taskComplete = new HashMap<KarmaSource, Consumer<Integer>>();
    private static final Map<Integer, Runnable> tasks = new HashMap<Integer, Runnable>();
    private final KarmaSource source;
    private static ScheduledExecutorService runner;
    private static int taskId;
    private static int current_task;

    public AsyncScheduler(T src) {
        int threadCount;
        this.source = src;
        boolean initialize = false;
        if (runner == null) {
            threadCount = Math.abs(Runtime.getRuntime().availableProcessors() / 2);
            if (threadCount <= 0) {
                threadCount = 1;
            }
            runner = Executors.newScheduledThreadPool(threadCount);
            initialize = true;
        }
        if (!runner.isShutdown() || runner.isTerminated()) {
            threadCount = Math.abs(Runtime.getRuntime().availableProcessors() / 2);
            if (threadCount <= 0) {
                threadCount = 1;
            }
            runner = Executors.newScheduledThreadPool(threadCount);
            initialize = true;
        }
        if (initialize) {
            runner.scheduleAtFixedRate(() -> {
                Runnable task;
                Object[] ids = tasks.keySet().toArray(new Integer[0]);
                Arrays.sort(ids);
                current_task = (Integer)ids[0];
                if (tasks.containsKey(current_task) && (task = tasks.remove(current_task)) != null) {
                    Consumer start = taskStart.getOrDefault(this.source, null);
                    Consumer complete = taskComplete.getOrDefault(this.source, null);
                    runner.execute(() -> {
                        if (start != null) {
                            start.accept(current_task);
                        }
                        task.run();
                        if (complete != null) {
                            complete.accept(current_task);
                        }
                    });
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void onTaskStart(Consumer<Integer> paramConsumer) {
        taskStart.put(this.source, paramConsumer);
    }

    @Override
    public void onTaskComplete(Consumer<Integer> paramConsumer) {
        taskComplete.put(this.source, paramConsumer);
    }

    @Override
    public int queue(Runnable paramRunnable) {
        tasks.put(taskId++, paramRunnable);
        return taskId - 1;
    }

    @Override
    public int currentTask() {
        return current_task;
    }

    static {
        taskId = 0;
        current_task = 0;
    }
}

