/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.serializer;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.FileUtilities;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.file.PathUtilities;

public final class SerializedFile {
    private final boolean directory;
    private final String name;
    private final byte[] data;

    public SerializedFile(boolean dir, String n, byte[] content) {
        this.directory = dir;
        this.name = n;
        this.data = content;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public void restore(File destination) {
        if (!this.directory) {
            try {
                File tmp;
                if (this.name.contains("/")) {
                    String[] data;
                    StringBuilder builder = new StringBuilder();
                    for (String sub : data = this.name.split("/")) {
                        builder.append(sub).append("/");
                    }
                    String sub = builder.toString();
                    tmp = new File(destination, sub.substring(0, sub.length() - 1));
                } else {
                    tmp = new File(destination, this.name);
                }
                FileUtilities.create(tmp);
                FileOutputStream stream = new FileOutputStream(tmp);
                stream.write(this.data);
                stream.flush();
                stream.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public void restore(Path destination) {
        if (!this.directory) {
            try {
                Path tmp = destination;
                if (this.name.contains("/")) {
                    String[] data;
                    for (String sub : data = this.name.split("/")) {
                        tmp = tmp.resolve(sub);
                    }
                } else {
                    tmp = tmp.resolve(this.name);
                }
                PathUtilities.create(tmp);
                FileOutputStream stream = new FileOutputStream(tmp.toFile());
                stream.write(this.data);
                stream.flush();
                stream.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

