/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ml.karmaconfigs.remote.messaging.karmaapi.common.JavaVM;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.PrefixConsoleData;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.GlobalPlaceholderEngine;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.SimplePlaceholder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.placeholder.util.Placeholder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.ComparatorBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.OptionsBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.RandomString;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.VersionComparator;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.color.ConsoleColor;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.SplitIndex;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.time.CleanTimeBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.time.TimeName;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static char SINGLE_COLOR_IDENTIFIER = (char)38;
    private static final List<Character> COLOR_LETTERS = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('r'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'));
    private static final Map<Pattern, String> NON_WINDOWS_REPLACEMENT = new ConcurrentHashMap<Pattern, String>();
    private static final Map<Pattern, String> WINDOWS_REPLACEMENT = new ConcurrentHashMap<Pattern, String>();

    public static String replaceLast(String text, String regex, String replace) {
        try {
            return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replace);
        }
        catch (Throwable ex) {
            try {
                return StringUtils.escapeString(text).replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replace);
            }
            catch (Throwable exc) {
                try {
                    return StringUtils.escapeString(text).replaceFirst("(?s)" + StringUtils.escapeString(regex) + "(?!.*?" + StringUtils.escapeString(regex) + ")", replace);
                }
                catch (Throwable exce) {
                    return StringUtils.escapeString(text).replaceFirst("(?s)" + StringUtils.escapeString(regex) + "(?!.*?" + StringUtils.escapeString(regex) + ")", StringUtils.escapeString(replace));
                }
            }
        }
    }

    public static String insertInEach(String text, String insert, int period) {
        String[] data;
        StringBuilder builder = new StringBuilder(text.length() + insert.length() * (text.length() / period) + 1);
        String prefix = "";
        for (int index = 0; index < text.length(); index += period) {
            builder.append(prefix);
            prefix = insert;
            builder.append(text, index, Math.min(index + period, text.length()));
        }
        StringBuilder fixed = new StringBuilder();
        for (String str : data = builder.toString().split(insert)) {
            if (str.startsWith(" ")) {
                char charAt;
                int character = 0;
                for (int i = 0; i < str.length() && Character.isSpaceChar(charAt = str.charAt(i)); ++i) {
                    ++character;
                }
                fixed.append(str.substring(character)).append(insert);
                continue;
            }
            fixed.append(str).append(insert);
        }
        return StringUtils.replaceLast(fixed.toString(), insert, "");
    }

    public static String smartReplace(String text, char replacement, int start, int max, char ... ignored) {
        StringBuilder builder = max == 0 ? new StringBuilder() : new StringBuilder(text.substring(0, start));
        HashSet<Character> charIgnored = new HashSet<Character>();
        for (char character : ignored) {
            charIgnored.add(Character.valueOf(character));
        }
        for (int i = start; i < max; ++i) {
            char character = text.charAt(i);
            System.out.println(character);
            if (!charIgnored.contains(Character.valueOf(character))) {
                builder.append(replacement);
                continue;
            }
            builder.append(character);
        }
        if (max != text.length()) {
            builder.append(text.substring(max));
        }
        return builder.toString();
    }

    public static String insertInEachSpace(String text, String insert, int period, boolean replaceSpace) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (index++ < period) continue;
            char character = text.charAt(i);
            if (Character.isSpaceChar(character)) {
                builder.append(replaceSpace ? insert : character + insert);
            } else {
                builder.append(character);
            }
            index = 0;
        }
        return builder.toString();
    }

    public static String[] splitInEach(String text, int period) {
        String result = StringUtils.insertInEach(text, "\n", period);
        if (result.contains("\n")) {
            return result.split("\n");
        }
        return new String[]{result};
    }

    public static String[] splitInEachSpace(String text, int period, boolean replaceSpace) {
        String result = StringUtils.insertInEachSpace(text, "\n", period, replaceSpace);
        if (result.contains("\n")) {
            return result.split("\n");
        }
        return new String[]{result};
    }

    public static String[] splitBetween(String text, int start, int end) {
        String extra;
        String then;
        String before;
        if (start != 0) {
            before = text.substring(0, start);
            then = text.substring(start, end);
            extra = end != text.length() ? text.substring(end) : null;
        } else {
            before = text.substring(start, end);
            then = end != text.length() ? text.substring(end) : null;
            extra = null;
        }
        return new String[]{before, then, extra};
    }

    public static String[] splitBetween(String text, SplitIndex ... indexes) {
        ArrayList<String> sliced = new ArrayList<String>();
        if (indexes.length > 0) {
            for (int i = 0; i < indexes.length; ++i) {
                int nextStart;
                SplitIndex index = indexes[i];
                SplitIndex next = null;
                if (i + 1 != indexes.length) {
                    next = indexes[i + 1];
                }
                int start = index.getStart();
                int end = index.getEnd();
                if (start != 0 && i == 0) {
                    String result = text.substring(0, start);
                    sliced.add(result);
                }
                String tmpResult = text.substring(start, end);
                sliced.add(tmpResult);
                if (end != text.length() && i == indexes.length - 1) {
                    String result = text.substring(end);
                    sliced.add(result);
                    continue;
                }
                if (i == indexes.length - 1 || next == null || (nextStart = next.getStart()) == end) continue;
                String result = text.substring(end, nextStart);
                sliced.add(result);
            }
        } else {
            sliced.add(text);
        }
        return sliced.toArray(new String[0]);
    }

    public static String glue(String ... array) {
        StringBuilder builder = new StringBuilder();
        for (String str : array) {
            builder.append(str);
        }
        return builder.toString();
    }

    public static String toColor(String text) {
        String str = text;
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        for (String color_code : color_codes) {
            str = str.replace(color_code, color_code.replace('&', '\u00a7'));
        }
        return str;
    }

    @Deprecated
    public static String toConsoleColor(CharSequence text) {
        String str = String.valueOf(text);
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color_codes.add(String.valueOf(curr).replace("\u00a7", "&") + next);
        }
        for (String color_code : color_codes) {
            String tmp_color = "\u001b[0m";
            switch (color_code.toLowerCase()) {
                case "&0": {
                    tmp_color = "\u001b[0;30m";
                    break;
                }
                case "&1": {
                    tmp_color = "\u001b[0;34m";
                    break;
                }
                case "&2": {
                    tmp_color = "\u001b[0;32m";
                    break;
                }
                case "&3": {
                    tmp_color = "\u001b[0;36m";
                    break;
                }
                case "&4": {
                    tmp_color = "\u001b[0;31m";
                    break;
                }
                case "&5": {
                    tmp_color = "\u001b[0;35m";
                    break;
                }
                case "&6": {
                    tmp_color = "\u001b[0;33m";
                    break;
                }
                case "&7": {
                    tmp_color = "\u001b[0;37m";
                    break;
                }
                case "&8": {
                    tmp_color = "\u001b[0;90m";
                    break;
                }
                case "&9": {
                    tmp_color = "\u001b[0;94m";
                    break;
                }
                case "&a": {
                    tmp_color = "\u001b[0;92m";
                    break;
                }
                case "&b": {
                    tmp_color = "\u001b[0;96m";
                    break;
                }
                case "&c": {
                    tmp_color = "\u001b[0;91m";
                    break;
                }
                case "&d": {
                    tmp_color = "\u001b[0;95m";
                    break;
                }
                case "&e": {
                    tmp_color = "\u001b[0;93m";
                    break;
                }
                case "&f": {
                    tmp_color = "\u001b[0;97m";
                    break;
                }
                case "&r": {
                    tmp_color = "\u001b[0m";
                }
            }
            str = str.replace(color_code, tmp_color);
        }
        return str;
    }

    public static String toAnyOsColor(CharSequence text) {
        String str = text.toString().replace("\u00a7", "&");
        switch (JavaVM.getSystem()) {
            case WINDOWS: {
                for (Pattern pattern : WINDOWS_REPLACEMENT.keySet()) {
                    Matcher matcher = pattern.matcher(str);
                    str = matcher.replaceAll(WINDOWS_REPLACEMENT.get(pattern));
                }
                break;
            }
            default: {
                for (Pattern pattern : NON_WINDOWS_REPLACEMENT.keySet()) {
                    Matcher matcher = pattern.matcher(str);
                    str = matcher.replaceAll(NON_WINDOWS_REPLACEMENT.get(pattern));
                }
            }
        }
        return str;
    }

    public static String fromAnyOsColor(CharSequence text) {
        String str = text.toString().replace("\u00a7", "&");
        switch (JavaVM.getSystem()) {
            case WINDOWS: {
                for (Pattern pattern : WINDOWS_REPLACEMENT.keySet()) {
                    String replacement = WINDOWS_REPLACEMENT.getOrDefault(pattern, null);
                    if (replacement == null) continue;
                    str = str.replace(replacement, pattern.pattern());
                }
                break;
            }
            default: {
                for (Pattern pattern : NON_WINDOWS_REPLACEMENT.keySet()) {
                    String replacement = NON_WINDOWS_REPLACEMENT.getOrDefault(pattern, null);
                    if (replacement == null) continue;
                    str = str.replace(replacement, pattern.pattern());
                }
            }
        }
        return str;
    }

    public static List<String> toColor(List<String> texts) {
        ArrayList<String> newTexts = new ArrayList<String>();
        HashSet<String> color_codes = new HashSet<String>();
        for (String text : texts) {
            for (int x = 0; x < text.length(); ++x) {
                char curr = text.charAt(x);
                char next = '\u0000';
                if (x + 1 != text.length()) {
                    next = text.charAt(x + 1);
                }
                if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
                color_codes.add(String.valueOf(curr) + next);
            }
            for (String color_code : color_codes) {
                text = text.replace(color_code, color_code.replace('&', '\u00a7'));
            }
            newTexts.add(text);
        }
        return newTexts;
    }

    public static Set<String> getColors(String text) {
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        return color_codes;
    }

    public static String getLastColor(String text) {
        String color = "";
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color = String.valueOf(curr) + next;
        }
        return color;
    }

    public static String getLastColor(List<String> texts, int index) {
        String color = "";
        int tmpIndex = index;
        if (index == texts.size()) {
            --tmpIndex;
        }
        if (texts.size() > tmpIndex) {
            try {
                String text = texts.get(tmpIndex);
                for (int i = 0; i < text.length(); ++i) {
                    char curr = text.charAt(i);
                    char next = '\u0000';
                    if (i + 1 != text.length()) {
                        next = text.charAt(i + 1);
                    }
                    if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
                    color = String.valueOf(curr) + next;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return color;
    }

    public static Set<Character> getCharColors(String text) {
        LinkedHashSet<Character> color_codes = new LinkedHashSet<Character>();
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&') continue;
            color_codes.add(Character.valueOf(next));
        }
        return color_codes;
    }

    public static char getLastCharColor(String text) {
        char color = '\u0000';
        for (int i = 0; i < text.length(); ++i) {
            char curr = text.charAt(i);
            char next = '\u0000';
            if (i + 1 != text.length()) {
                next = text.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color = next;
        }
        return color;
    }

    public static char getLastCharColor(List<String> texts, int index) {
        char color = '\u0000';
        int tmpIndex = index;
        if (index == texts.size()) {
            --tmpIndex;
        }
        if (texts.size() > tmpIndex) {
            try {
                String text = texts.get(tmpIndex);
                for (int i = 0; i < text.length(); ++i) {
                    char curr = text.charAt(i);
                    char next = '\u0000';
                    if (i + 1 != text.length()) {
                        next = text.charAt(i + 1);
                    }
                    if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
                    color = next;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return color;
    }

    public static String stripColor(String text) {
        String str = text;
        HashSet<String> color_codes = new HashSet<String>();
        for (int i = 0; i < str.length(); ++i) {
            char curr = str.charAt(i);
            char next = '\u0000';
            if (i + 1 != str.length()) {
                next = str.charAt(i + 1);
            }
            if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
            color_codes.add(String.valueOf(curr) + next);
        }
        for (String color_code : color_codes) {
            str = str.replace(color_code, "");
        }
        return str;
    }

    public static List<String> stripColor(List<String> texts) {
        ArrayList<String> newTexts = new ArrayList<String>();
        for (String text : texts) {
            HashSet<String> color_codes = new HashSet<String>();
            for (int x = 0; x < text.length(); ++x) {
                char curr = text.charAt(x);
                char next = '\u0000';
                if (x + 1 != text.length()) {
                    next = text.charAt(x + 1);
                }
                if (next == '\u0000' || Character.isSpaceChar(next) || curr != '&' && curr != '\u00a7') continue;
                color_codes.add(String.valueOf(curr) + next);
            }
            for (String color_code : color_codes) {
                text = text.replace(color_code, "");
            }
            newTexts.add(text);
        }
        return newTexts;
    }

    public static RandomString generateString() {
        return new RandomString();
    }

    public static RandomString generateString(OptionsBuilder options) {
        return new RandomString(options);
    }

    public static String randomColor() {
        ConsoleColor color;
        ConsoleColor[] colors = ConsoleColor.values();
        int random = new Random().nextInt(colors.length);
        if (random == colors.length) {
            --random;
        }
        if ((color = colors[random]).isCustom()) {
            color = ConsoleColor.customColor("k");
        }
        return color.getCode();
    }

    public static String formatString(CharSequence text, Object ... replaces) {
        String str = String.valueOf(text);
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            Object valObj = replaces[i];
            String val = "[unknown]";
            if (valObj != null) {
                try {
                    val = valObj.toString();
                }
                catch (Throwable ex) {
                    val = String.valueOf(replaces[i]);
                }
            }
            str = str.replace(placeholder, val);
        }
        return str;
    }

    @Deprecated
    public static String formatString(CharSequence text, Map<String, Object> replaces) {
        HashSet<SimplePlaceholder<Object>> placeholders = new HashSet<SimplePlaceholder<Object>>();
        for (String key : replaces.keySet()) {
            Object value = replaces.getOrDefault(key, null);
            if (value == null) continue;
            placeholders.add(new SimplePlaceholder<Object>(key, value));
        }
        GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
        placeholders.forEach(xva$0 -> engine.forceRegister((Placeholder<?>)xva$0));
        return engine.parse(String.valueOf(text), new Object[0]);
    }

    public static String formatString(KarmaSource owner, CharSequence text, Level level) {
        String tmpMessage = String.valueOf(text);
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = new PrefixConsoleData(owner);
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        return prefix + tmpMessage;
    }

    public static String formatString(KarmaSource owner, CharSequence text, Level level, Object ... replaces) {
        String tmpMessage = String.valueOf(text);
        String prefix = "&b[ &fALERT &b] &7NONE: &b";
        PrefixConsoleData data = new PrefixConsoleData(owner);
        switch (level) {
            case OK: {
                prefix = data.getOkPrefix();
                break;
            }
            case INFO: {
                prefix = data.getInfoPrefix();
                break;
            }
            case WARNING: {
                prefix = data.getWarningPrefix();
                break;
            }
            case GRAVE: {
                prefix = data.getGravePrefix();
            }
        }
        for (int i = 0; i < replaces.length; ++i) {
            String placeholder = "{" + i + "}";
            String value = String.valueOf(replaces[i]);
            tmpMessage = tmpMessage.replace(placeholder, value);
        }
        tmpMessage = StringUtils.stripColor(tmpMessage);
        return prefix + tmpMessage;
    }

    public static String readFrom(File file) {
        try {
            byte[] encoded = Files.readAllBytes(file.toPath());
            return new String(encoded, StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            return "";
        }
    }

    public static String listToString(List<String> lines, boolean spaces) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (spaces) {
                builder.append(line).append(i < lines.size() - 1 ? " " : "");
                continue;
            }
            builder.append(line).append(i < lines.size() - 1 ? "\n" : "");
        }
        return builder.toString();
    }

    public static String unEscapeString(String text) {
        return text.replaceAll("\\\\", "");
    }

    public static String escapeString(String text) {
        StringBuilder builder = new StringBuilder();
        block3: for (int i = 0; i < text.length(); ++i) {
            Character character = Character.valueOf(text.charAt(i));
            switch (character.charValue()) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    builder.append("\\").append(character);
                    continue block3;
                }
                default: {
                    builder.append(character);
                }
            }
        }
        return builder.toString();
    }

    public static <T> String serialize(T instance) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream so = new ObjectOutputStream(bo);
            so.writeObject(instance);
            so.flush();
            return Base64.getEncoder().encodeToString(bo.toByteArray());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Nullable
    public static Object load(String instance) {
        try {
            byte[] bytes = Base64.getDecoder().decode(instance);
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream si = new ObjectInputStream(bi);
            return si.readObject();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Nullable
    public static <T> T loadUnsafe(String instance) {
        return (T)StringUtils.load(instance);
    }

    public static boolean containsLetters(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!Character.isLetter(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNumbers(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (!Character.isDigit(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Object check) {
        if (check instanceof Object[]) {
            Object[] array = (Object[])check;
            return array.length <= 0;
        }
        if (check instanceof Iterable) {
            Iterable collection = (Iterable)check;
            boolean parsed = false;
            for (Object obj : collection) {
                if (String.valueOf(obj).replaceAll("\\s", "").isEmpty() || obj.toString().replaceAll("\\s", "").isEmpty()) {
                    return true;
                }
                parsed = true;
            }
            return !parsed;
        }
        if (check != null) {
            return String.valueOf(check).replaceAll("\\s", "").isEmpty() || check.toString().replaceAll("\\s", "").isEmpty();
        }
        return true;
    }

    public static boolean areNullOrEmpty(Object ... checks) {
        for (Object check : checks) {
            if (check != null) {
                if (check instanceof Object[]) {
                    Object[] array = (Object[])check;
                    if (array.length > 0) continue;
                    return true;
                }
                if (check instanceof Iterable) {
                    Iterable collection = (Iterable)check;
                    for (Object obj : collection) {
                        if (!StringUtils.isNullOrEmpty(obj)) continue;
                        return true;
                    }
                    continue;
                }
                if (!String.valueOf(check).replaceAll("\\s", "").isEmpty() && !check.toString().replaceAll("\\s", "").isEmpty()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean areNullOrEmpty(boolean checkAll, Object ... checks) {
        int nullOrEmpty = 0;
        for (Object check : checks) {
            if (check != null) {
                if (check instanceof Object[]) {
                    Object[] array = (Object[])check;
                    if (array.length > 0) continue;
                    if (!checkAll) {
                        return true;
                    }
                    ++nullOrEmpty;
                    continue;
                }
                if (check instanceof Iterable) {
                    Iterable collection = (Iterable)check;
                    for (Object obj : collection) {
                        if (!StringUtils.isNullOrEmpty(obj)) continue;
                        if (checkAll) {
                            return true;
                        }
                        ++nullOrEmpty;
                    }
                    continue;
                }
                if (!String.valueOf(check).replaceAll("\\s", "").isEmpty() && !check.toString().replaceAll("\\s", "").isEmpty()) continue;
                if (!checkAll) {
                    return true;
                }
                ++nullOrEmpty;
                continue;
            }
            if (!checkAll) {
                return true;
            }
            ++nullOrEmpty;
        }
        return nullOrEmpty == checks.length;
    }

    public static boolean equals(String str1, String str2) {
        int i;
        byte[] tmp;
        ArrayList<Byte> bytes;
        int diff;
        byte[] sum1 = str1.getBytes(StandardCharsets.UTF_8);
        byte[] sum2 = str2.getBytes(StandardCharsets.UTF_8);
        int high = sum1.length;
        if (sum1.length < sum2.length) {
            high = sum2.length;
            diff = high - sum1.length;
            bytes = new ArrayList();
            for (int i2 = 0; i2 < diff; ++i2) {
                bytes.add((byte)0);
            }
            for (byte b : sum1) {
                bytes.add(b);
            }
            tmp = new byte[bytes.size()];
            for (i = 0; i < bytes.size(); ++i) {
                tmp[i] = (Byte)bytes.get(i);
            }
            sum1 = tmp;
        } else {
            diff = high - sum2.length;
            bytes = new ArrayList<Byte>();
            for (int i3 = 0; i3 < diff; ++i3) {
                bytes.add((byte)0);
            }
            byte[] i3 = sum2;
            i = i3.length;
            for (int j = 0; j < i; ++j) {
                byte b;
                b = i3[j];
                bytes.add(b);
            }
            tmp = new byte[bytes.size()];
            for (i = 0; i < bytes.size(); ++i) {
                tmp[i] = (Byte)bytes.get(i);
            }
            sum2 = tmp;
        }
        for (int i4 = 0; i4 < high; ++i4) {
            byte b1 = sum1[i4];
            byte b2 = sum2[i4];
            String bin1 = Integer.toBinaryString(b1);
            String bin2 = Integer.toBinaryString(b2);
            int max = bin1.length();
            if (bin1.length() < bin2.length()) {
                max = bin2.length();
                bin1 = String.format("%0" + max + "d", Integer.parseInt(bin1));
            } else {
                bin2 = String.format("%0" + max + "d", Integer.parseInt(bin2));
            }
            for (int x = 0; x < max; ++x) {
                int s2;
                char b1char = bin1.charAt(x);
                char b2char = bin2.charAt(x);
                String b1str = String.valueOf(b1char);
                String b2str = String.valueOf(b2char);
                int s1 = Integer.parseInt(b1str);
                if (s1 == (s2 = Integer.parseInt(b2str))) continue;
                return false;
            }
        }
        return true;
    }

    public static VersionComparator compareTo(ComparatorBuilder builder) {
        return new VersionComparator(builder);
    }

    public static String removeNumbers(CharSequence original) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (Character.isDigit(character)) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String removeLetters(CharSequence original) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (Character.isLetter(character)) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String parseNumbers(CharSequence original, Character ... keep) {
        StringBuilder builder = new StringBuilder();
        Set<Character> chars = StringUtils.arrayToSet(keep);
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (!Character.isDigit(character) && !chars.contains(Character.valueOf(character))) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String parseLetters(CharSequence original, Character ... keep) {
        StringBuilder builder = new StringBuilder();
        Set<Character> chars = StringUtils.arrayToSet(keep);
        for (int i = 0; i < original.length(); ++i) {
            char character = original.charAt(i);
            if (!Character.isLetter(character) && !chars.contains(Character.valueOf(character))) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String timeToString(long milliseconds) {
        CleanTimeBuilder builder = new CleanTimeBuilder(TimeName.create(), milliseconds);
        return builder.create();
    }

    public static String timeToString(long milliseconds, TimeName name) {
        CleanTimeBuilder builder = new CleanTimeBuilder(name, milliseconds);
        return builder.create();
    }

    public static <T> Set<T> arrayToSet(T[] array) {
        return new HashSet<T>(Arrays.asList(array));
    }

    static {
        for (Character character : COLOR_LETTERS) {
            Pattern pattern = Pattern.compile(String.valueOf(SINGLE_COLOR_IDENTIFIER) + character);
            switch (character.charValue()) {
                case '0': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;0;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[30m");
                    break;
                }
                case '1': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;0;128m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[94m");
                    break;
                }
                case '2': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;128;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[92m");
                    break;
                }
                case '3': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;128;128m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[96m");
                    break;
                }
                case '4': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;128;0;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[91m");
                    break;
                }
                case '5': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;128;0;128m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[95m");
                    break;
                }
                case '6': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;128;128;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[93m");
                    break;
                }
                case '7': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;192;192;192m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[90m");
                    break;
                }
                case '8': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;128;128;128m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[97m");
                    break;
                }
                case '9': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;95;255m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[34m");
                    break;
                }
                case 'a': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;255;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[32m");
                    break;
                }
                case 'b': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;0;255;255m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[36m");
                    break;
                }
                case 'c': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;255;0;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[31m");
                    break;
                }
                case 'd': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;255;0;255m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[35m");
                    break;
                }
                case 'e': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;255;255;0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[33m");
                    break;
                }
                case 'f': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0;38;2;255;255;255m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[37m");
                    break;
                }
                case 'r': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[0m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[0m");
                    break;
                }
                case 'l': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[1m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[1m");
                    break;
                }
                case 'n': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[4m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[4m");
                    break;
                }
                case 'o': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[3m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[3m");
                    break;
                }
                case 'm': {
                    NON_WINDOWS_REPLACEMENT.put(pattern, "\u001b[9m");
                    WINDOWS_REPLACEMENT.put(pattern, "\u001b[9m");
                    break;
                }
            }
        }
    }
}

