/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string;

import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.ComparatorBuilder;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.util.VersionDiff;

public class VersionComparator {
    private ComparatorBuilder options;

    private VersionComparator() {
    }

    VersionComparator(ComparatorBuilder opts) {
        this.options = opts;
    }

    public VersionDiff getDifference() {
        String[] currentParts = this.options.getCurrentVersion().split("\\.");
        String[] checkParts = this.options.getCheckVersion().split("\\.");
        int length = Math.max(currentParts.length, checkParts.length);
        for (int i = 0; i < length; ++i) {
            try {
                int checkPart;
                int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                int n = checkPart = i < checkParts.length ? Integer.parseInt(checkParts[i]) : 0;
                if (currentPart < checkPart) {
                    return VersionDiff.OUTDATED;
                }
                if (currentPart <= checkPart) continue;
                return VersionDiff.OVERDATED;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return VersionDiff.UPDATED;
    }

    public boolean isUpToDate() {
        return !this.getDifference().equals((Object)VersionDiff.OUTDATED);
    }

    public static ComparatorBuilder createBuilder() {
        return new ComparatorBuilder();
    }
}

