/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.Identifiable;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.function.ThrowingBiConsumer;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;
import org.burningwave.core.iterable.TaskBasedIterator;
import org.burningwave.core.iterable.ThreadBasedIterator;

public class IterableObjectHelperImpl
implements IterableObjectHelper,
Properties.Listener,
Identifiable {
    Predicate<Object> defaultMinimumCollectionSizeForParallelIterationPredicate;
    private String defaultValuesSeparator;
    private Integer maxThreadCountsForParallelIteration;
    private Supplier<Class<?>[]> parallelCollectionClassesSupplier;
    private Class<?>[] parallelCollectionClasses;

    IterableObjectHelperImpl(Map<?, ?> config) {
        this.defaultValuesSeparator = this.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.ForNamedKey.forNamedKey("iterable-object-helper.default-values-separator").on(config));
        this.defaultMinimumCollectionSizeForParallelIterationPredicate = this.buildDefaultMinimumCollectionSizeForParallelIterationPredicate(config);
        this.maxThreadCountsForParallelIteration = this.computeMaxRuntimeThreadsCountThreshold(config);
        this.parallelCollectionClassesSupplier = () -> this.retrieveParallelCollectionClasses(config);
    }

    private Class<?>[] retrieveParallelCollectionClasses(Map<?, ?> config) {
        LinkedHashSet parallelCollectionClasses = new LinkedHashSet();
        Collection<String> classNames = this.resolveStringValues((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.ForNamedKey.forNamedKey("iterable-object-helper.parallel-iteration.applicability.output-collection-enabled-types").on(config));
        if (classNames != null) {
            for (String className : classNames) {
                parallelCollectionClasses.add(StaticComponentContainer.Driver.getClassByName(className, false, this.getClass().getClassLoader(), this.getClass()));
            }
        }
        return parallelCollectionClasses.toArray(new Class[parallelCollectionClasses.size()]);
    }

    private Predicate<Object> buildDefaultMinimumCollectionSizeForParallelIterationPredicate(Map<?, ?> config) {
        int defaultMinimumCollectionSizeForParallelIteration = StaticComponentContainer.Objects.toInt(this.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.ForNamedKey.forNamedKey("iterable-object-helper.parallel-iteration.applicability.default-minimum-collection-size").on(config)));
        if (defaultMinimumCollectionSizeForParallelIteration >= 0) {
            return coll -> (coll instanceof Collection ? ((Collection)coll).size() : Array.getLength(coll)) >= defaultMinimumCollectionSizeForParallelIteration;
        }
        return coll -> false;
    }

    @Override
    public String getDefaultValuesSeparator() {
        return this.defaultValuesSeparator;
    }

    @Override
    public Predicate<Object> getDefaultMinimumCollectionSizeForParallelIterationPredicate() {
        return this.defaultMinimumCollectionSizeForParallelIterationPredicate;
    }

    Integer computeMaxRuntimeThreadsCountThreshold(Map<?, ?> config) {
        try {
            return StaticComponentContainer.Objects.toInt(this.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.ForNamedKey.forNamedKey("iterable-object-helper.parallel-iteration.applicability.max-runtime-thread-count-threshold").on(config)));
        }
        catch (Throwable exc) {
            return this.autodetectMaxRuntimeThreadsCountThreshold();
        }
    }

    private Integer autodetectMaxRuntimeThreadsCountThreshold() {
        if (StaticComponentContainer.ThreadSupplier != null) {
            if (StaticComponentContainer.ThreadSupplier.getMaxDetachedThreadCountIncreasingStep() > 0) {
                return Integer.MAX_VALUE;
            }
            return StaticComponentContainer.ThreadSupplier.getInititialMaxThreadCount();
        }
        return null;
    }

    @Override
    public <K, V> void processChangeNotification(Properties config, Properties.Event event, K key, V newValue, V previousValue) {
        if (event.name().equals(Properties.Event.PUT.name()) && key.equals("iterable-object-helper.default-values-separator") && newValue != null) {
            this.defaultValuesSeparator = (String)newValue;
        }
        if (event.name().equals(Properties.Event.PUT.name()) && key.equals("iterable-object-helper.parallel-iteration.applicability.default-minimum-collection-size") && newValue != null) {
            this.defaultMinimumCollectionSizeForParallelIterationPredicate = this.buildDefaultMinimumCollectionSizeForParallelIterationPredicate(config);
        }
        if (event.name().equals(Properties.Event.PUT.name()) && key.equals("iterable-object-helper.parallel-iteration.applicability.max-runtime-thread-count-threshold")) {
            this.maxThreadCountsForParallelIteration = this.computeMaxRuntimeThreadsCountThreshold(config);
        }
        if (event.name().equals(Properties.Event.PUT.name()) && key.equals("iterable-object-helper.parallel-iteration.applicability.output-collection-enabled-types")) {
            this.parallelCollectionClasses = this.retrieveParallelCollectionClasses(config);
        }
    }

    @Override
    public <K, V> void deepClear(Map<K, V> map) {
        java.util.Iterator<Map.Entry<K, V>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public <K, V, E extends Throwable> void deepClear(Map<K, V> map, ThrowingBiConsumer<K, V, E> itemDestroyer) throws E {
        java.util.Iterator<Map.Entry<K, V>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<K, V> entry = itr.next();
            try {
                itr.remove();
                itemDestroyer.accept(entry.getKey(), entry.getValue());
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred while removing and cleraring " + entry.getValue(), exc);
            }
        }
    }

    @Override
    public <V> void deepClear(Collection<V> map) {
        java.util.Iterator<V> itr = map.iterator();
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public <V, E extends Throwable> void deepClear(Collection<V> map, ThrowingConsumer<V, E> itemDestroyer) throws E {
        java.util.Iterator<V> itr = map.iterator();
        while (itr.hasNext()) {
            itr.remove();
            itemDestroyer.accept(itr.next());
        }
    }

    @Override
    public <T> Collection<T> merge(Supplier<Collection<T>> baseCollectionSupplier, Supplier<Collection<T>> additionalCollectionSupplier, Supplier<Collection<T>> defaultCollectionSupplier) {
        Collection mergedCollection = Optional.ofNullable(baseCollectionSupplier.get()).orElseGet(() -> (Collection)defaultCollectionSupplier.get());
        Collection<T> additionalClassPaths = additionalCollectionSupplier.get();
        if (additionalClassPaths != null) {
            mergedCollection.addAll(additionalClassPaths);
        }
        return mergedCollection;
    }

    @Override
    public <T> T getRandom(Collection<T> coll) {
        int num = (int)(Math.random() * (double)coll.size());
        for (T t : coll) {
            if (--num >= 0) continue;
            return t;
        }
        return null;
    }

    @Override
    public <T> Stream<T> retrieveStream(Object object) {
        Stream<T> stream = null;
        if (object != null) {
            if (object instanceof Collection) {
                return ((Collection)object).stream();
            }
            if (object.getClass().isArray()) {
                return Stream.of((Object[])object);
            }
            if (object instanceof Map) {
                return ((Map)object).entrySet().stream();
            }
        }
        return stream;
    }

    @Override
    public long getSize(Object object) {
        return this.retrieveStream(object).count();
    }

    @Override
    public <T> T resolveValue(IterableObjectHelper.ResolveConfig.ForNamedKey config) {
        return this.resolveValue(config.filter, () -> this.resolve(config.map, config.filter, config.valuesSeparator, config.defaultValueSeparator, config.deleteUnresolvedPlaceHolder, config.defaultValues));
    }

    @Override
    public <K, T> T resolveValue(IterableObjectHelper.ResolveConfig.ForAllKeysThat<K> config) {
        return this.resolveValue(config.filter, () -> this.resolve(config.map, config.filter, config.valuesSeparator, config.defaultValueSeparator, config.deleteUnresolvedPlaceHolder, config.defaultValues));
    }

    @Override
    public String resolveStringValue(IterableObjectHelper.ResolveConfig.ForNamedKey config) {
        return (String)this.resolveValue(config);
    }

    @Override
    public <K> String resolveStringValue(IterableObjectHelper.ResolveConfig.ForAllKeysThat<K> config) {
        return (String)this.resolveValue(config);
    }

    @Override
    public <T> Collection<T> resolveValues(IterableObjectHelper.ResolveConfig.ForNamedKey config) {
        return (Collection)this.resolve(config.map, config.filter, config.valuesSeparator != null ? config.valuesSeparator : (config.defaultValueSeparator != null ? config.defaultValueSeparator : this.defaultValuesSeparator), config.defaultValueSeparator, config.deleteUnresolvedPlaceHolder, config.defaultValues);
    }

    @Override
    public <K, V> Map<K, V> resolveValues(IterableObjectHelper.ResolveConfig.ForAllKeysThat<K> config) {
        return this.resolveForKeys(config.map, (Predicate)config.filter, config.valuesSeparator != null ? config.valuesSeparator : (config.defaultValueSeparator != null ? config.defaultValueSeparator : this.defaultValuesSeparator), config.defaultValueSeparator, config.deleteUnresolvedPlaceHolder, config.defaultValues);
    }

    @Override
    public Collection<String> resolveStringValues(IterableObjectHelper.ResolveConfig.ForNamedKey config) {
        return (Collection)this.resolve(config.map, config.filter, config.valuesSeparator != null ? config.valuesSeparator : (config.defaultValueSeparator != null ? config.defaultValueSeparator : this.defaultValuesSeparator), config.defaultValueSeparator, config.deleteUnresolvedPlaceHolder, config.defaultValues);
    }

    @Override
    public <K> Map<K, Collection<String>> resolveStringValues(IterableObjectHelper.ResolveConfig.ForAllKeysThat<K> config) {
        return this.resolveForKeys(config.map, (Predicate)config.filter, config.valuesSeparator != null ? config.valuesSeparator : (config.defaultValueSeparator != null ? config.defaultValueSeparator : this.defaultValuesSeparator), config.defaultValueSeparator, config.deleteUnresolvedPlaceHolder, config.defaultValues);
    }

    private <T> T resolveValue(Object key, Supplier<Object> valuesSupplier) {
        Object value = valuesSupplier.get();
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.size() > 1) {
                StaticComponentContainer.Driver.throwException("Found more than one item under key/predicate {}", key);
            }
            return (T)values.stream().findFirst().orElseGet(() -> null);
        }
        return (T)value;
    }

    private <K, V> Map<K, V> resolveForKeys(Map<?, ?> map, Predicate<K> keyPredicate, String valuesSeparator, String defaultValueSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        LinkedHashSet keys = new LinkedHashSet();
        for (Object key : map.keySet()) {
            try {
                if (!keyPredicate.test(key)) continue;
                keys.add(key);
            }
            catch (ClassCastException classCastException) {}
        }
        if (defaultValues != null) {
            for (Object key : defaultValues.keySet()) {
                try {
                    if (!keyPredicate.test(key)) continue;
                    keys.add(key);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        HashMap values = new HashMap();
        for (Object key : keys) {
            values.put(key, this.resolve(map, key, valuesSeparator, defaultValueSeparator, deleteUnresolvedPlaceHolder, defaultValues));
        }
        return values;
    }

    private <T> T resolve(Map<?, ?> map, Object key, String valuesSeparator, String defaultValueSeparator, boolean deleteUnresolvedPlaceHolder, Map<?, ?> defaultValues) {
        String valuesSeparatorForSplitting = valuesSeparator != null ? valuesSeparator : (defaultValueSeparator != null ? defaultValueSeparator : this.defaultValuesSeparator);
        Object value = map.get(key);
        if (value == null && defaultValues != null) {
            value = this.resolve(defaultValues, key, valuesSeparator, defaultValueSeparator, deleteUnresolvedPlaceHolder, null);
        }
        if (value != null && value instanceof String) {
            String stringValue = (String)value;
            ArrayList values = new ArrayList();
            if (!StaticComponentContainer.Strings.isEmpty(stringValue)) {
                Map<Integer, List<String>> subProperties = StaticComponentContainer.Strings.extractAllGroups(StaticComponentContainer.Strings.PLACE_HOLDER_NAME_EXTRACTOR_PATTERN, stringValue);
                if (!subProperties.isEmpty()) {
                    for (Map.Entry<Integer, List<String>> entry : subProperties.entrySet()) {
                        for (String placeHolder : entry.getValue()) {
                            String valueObjects = null;
                            if (!placeHolder.startsWith("system.properties:")) {
                                valueObjects = this.resolve(map, placeHolder, valuesSeparator, defaultValueSeparator, deleteUnresolvedPlaceHolder, defaultValues);
                            } else {
                                valueObjects = StaticComponentContainer.SystemProperties.get(placeHolder.split(":")[1]);
                                if (valuesSeparatorForSplitting != null) {
                                    valueObjects = valueObjects.replace(File.pathSeparator, valuesSeparatorForSplitting);
                                }
                            }
                            if (valueObjects == null) {
                                if (!deleteUnresolvedPlaceHolder) continue;
                                stringValue = stringValue.replaceAll("[^{" + valuesSeparatorForSplitting + "}]*?" + StaticComponentContainer.Strings.placeHolderToRegEx("${" + placeHolder + "}") + ".*?" + valuesSeparatorForSplitting, "");
                                continue;
                            }
                            ArrayList<String> replacements = new ArrayList<String>();
                            if (valueObjects instanceof ArrayList) {
                                replacements.addAll((Collection)((Object)valueObjects));
                            } else {
                                replacements.add(valueObjects);
                            }
                            String regExpPattern = null;
                            regExpPattern = stringValue.contains(valuesSeparatorForSplitting) ? "(.*?" + StaticComponentContainer.Strings.placeHolderToRegEx("${" + placeHolder + "}") + ".*?" + valuesSeparatorForSplitting + ")" : "(.*?" + StaticComponentContainer.Strings.placeHolderToRegEx("${" + placeHolder + "}") + ".*?)";
                            Map<Integer, List<String>> placeHolderedValues = StaticComponentContainer.Strings.extractAllGroups(Pattern.compile(regExpPattern), stringValue);
                            for (Map.Entry<Integer, List<String>> placeHolderedValuesEntry : placeHolderedValues.entrySet()) {
                                for (String placeHolderedValue : placeHolderedValuesEntry.getValue()) {
                                    String newReplacement = "";
                                    for (Object e : replacements) {
                                        if (e instanceof String) {
                                            String replacement = (String)e;
                                            if (valuesSeparator != null) {
                                                for (String replacementUnit : replacement.split(valuesSeparator)) {
                                                    newReplacement = newReplacement + placeHolderedValue.replace("${" + placeHolder + "}", replacementUnit);
                                                    newReplacement = newReplacement + (newReplacement.endsWith(valuesSeparator) ? "" : valuesSeparator);
                                                }
                                                continue;
                                            }
                                            newReplacement = newReplacement + placeHolderedValue.replace("${" + placeHolder + "}", replacement);
                                            continue;
                                        }
                                        values.add(e);
                                    }
                                    stringValue = stringValue.replace(placeHolderedValue, newReplacement);
                                }
                            }
                        }
                    }
                    if (stringValue != null && !stringValue.isEmpty()) {
                        if (valuesSeparator == null) {
                            values.add(stringValue);
                        } else {
                            for (String valueToAdd : stringValue.split(valuesSeparator)) {
                                values.add(valueToAdd);
                            }
                        }
                    }
                } else if (valuesSeparator != null) {
                    for (String valueToAdd : stringValue.split(valuesSeparator)) {
                        values.add(valueToAdd);
                    }
                } else {
                    values.add(stringValue);
                }
            }
            return (T)values;
        }
        return (T)value;
    }

    @Override
    public Collection<String> getAllPlaceHolders(Map<?, ?> map) {
        return this.getAllPlaceHolders(map, (String object) -> true);
    }

    @Override
    public Collection<String> getAllPlaceHolders(Map<?, ?> map, Predicate<String> propertyFilter) {
        HashSet<String> placeHolders = new HashSet<String>();
        for (Map.Entry entry2 : map.entrySet().stream().filter(entry -> (entry.getValue() == null || entry.getValue() instanceof String) && entry.getKey() instanceof String && propertyFilter.test((String)entry.getKey())).collect(Collectors.toSet())) {
            String value = (String)entry2.getValue();
            for (List<String> placeHoldersFound : StaticComponentContainer.Strings.extractAllGroups(StaticComponentContainer.Strings.PLACE_HOLDER_EXTRACTOR_PATTERN, value).values()) {
                placeHolders.addAll(placeHoldersFound);
            }
        }
        return placeHolders;
    }

    @Override
    public Collection<String> getAllPlaceHolders(Map<?, ?> map, String propertyName) {
        Collection<String> placeHolders = this.getAllPlaceHolders(map);
        java.util.Iterator<String> placeHoldersItr = placeHolders.iterator();
        while (placeHoldersItr.hasNext()) {
            if (this.containsValue(map, propertyName, placeHoldersItr.next())) continue;
            placeHoldersItr.remove();
        }
        return placeHolders;
    }

    @Override
    public boolean containsValue(Map<?, ?> map, String key, Object object) {
        return this.containsValue(map, key, object, null);
    }

    @Override
    public <K, V> void refresh(Map<K, V> source, Map<K, V> newValues) {
        K key;
        HashSet<K> keyToBeRemoved = new HashSet<K>();
        HashMap<K, V> keyAndValuesToBePut = new HashMap<K, V>();
        for (Map.Entry<K, V> keyAndValue : source.entrySet()) {
            key = keyAndValue.getKey();
            if (newValues.containsKey(key)) {
                V newValue;
                V oldValue = newValues.get(key);
                if (Objects.equals(oldValue, newValue = newValues.get(key))) continue;
                keyAndValuesToBePut.put(key, newValue);
                continue;
            }
            keyToBeRemoved.add(key);
        }
        for (Map.Entry<K, V> keyAndValue : newValues.entrySet()) {
            key = keyAndValue.getKey();
            if (source.containsKey(key)) continue;
            keyAndValuesToBePut.put(key, keyAndValue.getValue());
        }
        source.keySet().removeAll(keyToBeRemoved);
        source.putAll(keyAndValuesToBePut);
    }

    @Override
    public boolean containsValue(Map<?, ?> map, String key, Object object, Map<?, ?> defaultValues) {
        Object value = map.get(key);
        if (value == null && defaultValues != null) {
            value = defaultValues.get(key);
        }
        if (value != null && value instanceof String) {
            String stringValue;
            if (StaticComponentContainer.Strings.isEmpty((String)value) && defaultValues != null) {
                value = defaultValues.get(key);
            }
            if (value != null && value instanceof String && !StaticComponentContainer.Strings.isEmpty(stringValue = (String)value)) {
                String objectString;
                if (object instanceof String && stringValue.contains(objectString = (String)object)) {
                    return true;
                }
                Map<Integer, List<String>> subProperties = StaticComponentContainer.Strings.extractAllGroups(StaticComponentContainer.Strings.PLACE_HOLDER_NAME_EXTRACTOR_PATTERN, stringValue);
                if (!subProperties.isEmpty()) {
                    for (Map.Entry<Integer, List<String>> entry : subProperties.entrySet()) {
                        java.util.Iterator<String> iterator = entry.getValue().iterator();
                        if (!iterator.hasNext()) continue;
                        String propName = iterator.next();
                        return this.containsValue(map, propName, object, defaultValues);
                    }
                }
            }
        }
        return object != null && value != null && object.equals(value);
    }

    @Override
    public <I, IC, O, OC> QueuedTaskExecutor.ProducerTask<OC> createIterateAndGetTask(IterableObjectHelper.IterationConfig.WithOutputOfCollection<I, IC, O, OC> config) {
        return StaticComponentContainer.BackgroundExecutor.createProducerTask(() -> this.iterateAndGet(config));
    }

    @Override
    public <I, IC, K, O, OM> QueuedTaskExecutor.ProducerTask<OM> createIterateAndGetTask(IterableObjectHelper.IterationConfig.WithOutputOfMap<I, IC, K, O, OM> config) {
        return StaticComponentContainer.BackgroundExecutor.createProducerTask(() -> this.iterateAndGet(config));
    }

    @Override
    public <I, IC> QueuedTaskExecutor.Task createIterateTask(IterableObjectHelper.IterationConfig<I, IC, ?> config) {
        return StaticComponentContainer.BackgroundExecutor.createTask(() -> this.iterate(config));
    }

    @Override
    public <I, IC, K, O, OM> OM iterateAndGet(IterableObjectHelper.IterationConfig.WithOutputOfMap<I, IC, K, O, OM> configuration) {
        Iterator.Config config = configuration.getWrappedConfiguration();
        return (OM)config.iteratorSupplier.apply(this).iterate(config.items, config.predicateForParallelIteration, config.output, (BiConsumer)config.action, config.priority);
    }

    @Override
    public <I, IC, O, OC> OC iterateAndGet(IterableObjectHelper.IterationConfig.WithOutputOfCollection<I, IC, O, OC> configuration) {
        Iterator.Config config = configuration.getWrappedConfiguration();
        return (OC)config.iteratorSupplier.apply(this).iterate(config.items, config.predicateForParallelIteration, config.output, (BiConsumer)config.action, config.priority);
    }

    @Override
    public <I, IC> void iterate(IterableObjectHelper.IterationConfig<I, IC, ?> configuration) {
        Iterator.Config config = (Iterator.Config)configuration;
        config.iteratorSupplier.apply(this).iterate(config.items, config.predicateForParallelIteration, null, (BiConsumer)config.action, config.priority);
    }

    <I, D> int getCountOfTasksThatCanBeCreated(D items, Predicate<D> predicate) {
        Integer maxThreadCountsForParallelIteration = this.maxThreadCountsForParallelIteration;
        try {
            return this.getCountOfTasksThatCanBeCreated(items, predicate, maxThreadCountsForParallelIteration);
        }
        catch (NullPointerException exc) {
            if (maxThreadCountsForParallelIteration != null) {
                throw exc;
            }
            if (maxThreadCountsForParallelIteration == null) {
                StaticComponentContainer.Synchronizer.execute(this.getOperationId("initMaxThreadCountsForParallelIteration"), () -> {
                    if (this.maxThreadCountsForParallelIteration == null) {
                        this.maxThreadCountsForParallelIteration = this.autodetectMaxRuntimeThreadsCountThreshold();
                    }
                });
            }
            return this.getCountOfTasksThatCanBeCreated(items, predicate, this.maxThreadCountsForParallelIteration);
        }
    }

    private <D> int getCountOfTasksThatCanBeCreated(D items, Predicate<D> predicate, Integer maxThreadCountsForParallelIteration) {
        if (predicate.test(items) && maxThreadCountsForParallelIteration > StaticComponentContainer.ThreadSupplier.getRunningThreadCount()) {
            int taskCount = Math.min(Runtime.getRuntime().availableProcessors(), items instanceof Collection ? ((Collection)items).size() : Array.getLength(items));
            taskCount = Math.min(StaticComponentContainer.ThreadSupplier.getCountOfThreadsThatCanBeSupplied(), taskCount);
            return taskCount;
        }
        return 0;
    }

    boolean isConcurrentEnabled(Object coll) {
        Class<?>[] parallelCollectionClasses = this.parallelCollectionClasses;
        try {
            return this.isConcurrentEnabled(coll, parallelCollectionClasses);
        }
        catch (NullPointerException exc) {
            if (parallelCollectionClasses != null) {
                throw exc;
            }
            if (this.parallelCollectionClasses == null) {
                StaticComponentContainer.Synchronizer.execute(this.getOperationId("initParallelCollectionClassesCollection"), () -> {
                    if (this.parallelCollectionClasses == null) {
                        this.parallelCollectionClasses = this.parallelCollectionClassesSupplier.get();
                    }
                });
            }
            return this.isConcurrentEnabled(coll, this.parallelCollectionClasses);
        }
    }

    private boolean isConcurrentEnabled(Object coll, Class<?>[] parallelCollectionClasses) {
        for (Class<?> parallelCollectionsClass : parallelCollectionClasses) {
            if (!parallelCollectionsClass.isAssignableFrom(coll.getClass())) continue;
            return true;
        }
        return false;
    }

    private String toPrettyKeyValueLabel(Map.Entry<?, ?> entry, String valuesSeparator, int marginTabCount) {
        String margin = new String(new char[marginTabCount]).replace('\u0000', '\t');
        String keyValueLabel = margin + entry.getKey() + "=\\\n" + margin + "\t" + entry.getValue().toString().replace(valuesSeparator, valuesSeparator + "\\\n" + margin + "\t");
        keyValueLabel = keyValueLabel.endsWith(valuesSeparator + "\\\n" + margin + "\t") ? keyValueLabel.substring(0, keyValueLabel.lastIndexOf("\\\n" + margin + "\t")) : keyValueLabel;
        return keyValueLabel;
    }

    @Override
    public String toPrettyString(Map<?, ?> map, String valuesSeparator, int marginTabCount) {
        TreeMap<Object, Object> allValues = map instanceof TreeMap ? (TreeMap<Object, Object>)map : new TreeMap(map);
        return allValues.entrySet().stream().map(entry -> this.toPrettyKeyValueLabel((Map.Entry<?, ?>)entry, valuesSeparator, marginTabCount)).collect(Collectors.joining("\n"));
    }

    @Override
    public <K, V> String toString(Map<K, V> map, int marginTabCount) {
        return this.toString(map, key -> key.toString(), value -> value.toString(), marginTabCount);
    }

    @Override
    public <K, V> String toString(Map<K, V> map, Function<K, String> keyTransformer, Function<V, String> valueTransformer, int marginTabCount) {
        TreeMap allValues = map instanceof TreeMap ? (TreeMap)map : new TreeMap<K, V>(map);
        String margin = new String(new char[marginTabCount]).replace('\u0000', '\t');
        return allValues.entrySet().stream().map(entry -> margin + (String)keyTransformer.apply(entry.getKey()) + "=" + Optional.ofNullable(entry.getValue()).map(value -> (String)valueTransformer.apply(value)).orElseGet(() -> "null")).collect(Collectors.joining("\n"));
    }

    private class ArrayList<E>
    extends java.util.ArrayList<E> {
        private static final long serialVersionUID = -8096435103182655041L;

        private ArrayList() {
        }
    }

    static abstract class Iterator {
        static final Object NO_ITEMS = new Object();
        final IterableObjectHelperImpl iterableObjectHelper;

        public Iterator(IterableObjectHelperImpl iterableObjectHelper) {
            this.iterableObjectHelper = iterableObjectHelper;
        }

        abstract <I, IC, OC> OC iterate(IC var1, Predicate<IC> var2, OC var3, BiConsumer<I, Consumer<Consumer<OC>>> var4, Integer var5);

        <OC> Consumer<Consumer<OC>> buildOutputCollectionHandler(OC output) {
            Consumer<Consumer> outputItemsHandler = output != null ? (this.iterableObjectHelper.isConcurrentEnabled(output) ? outputHandler -> outputHandler.accept(output) : outputHandler -> {
                Object object = output;
                synchronized (object) {
                    outputHandler.accept(output);
                }
            }) : null;
            return outputItemsHandler;
        }

        void checkAndNotifyTerminationOfIteration(AtomicReference<IterableObjectHelper.TerminateIteration> terminateIterationNotification, IterableObjectHelper.TerminateIteration exc) {
            if (exc == IterableObjectHelper.TerminateIteration.NOTIFICATION) {
                terminateIterationNotification.set(exc);
            }
        }

        static class Config<I, IC>
        implements IterableObjectHelper.IterationConfig<I, IC, Config<I, IC>> {
            private static final Function<IterableObjectHelperImpl, Iterator> taskBasedIteratorSupplier = TaskBasedIterator::new;
            private static final Function<IterableObjectHelperImpl, Iterator> threadBasedIteratorSupplier = ThreadBasedIterator::new;
            Object items;
            Object action;
            Object output;
            Predicate<IC> predicateForParallelIteration;
            Integer priority;
            Function<IterableObjectHelperImpl, Iterator> iteratorSupplier;

            public Config(Object items) {
                if (items == null) {
                    throw new IllegalArgumentException("Input collection or array could not be null");
                }
                this.items = items;
                this.iteratorSupplier = taskBasedIteratorSupplier;
            }

            public <O> Config<I, IC> withAction(BiConsumer<I, Consumer<Consumer<O>>> action) {
                this.action = action;
                return this;
            }

            @Override
            public Config<I, IC> withAction(Consumer<I> action) {
                BiConsumer<Object, Consumer> newAction;
                this.action = newAction = (item, outputItemCollector) -> action.accept(item);
                return this;
            }

            @Override
            public Config<I, IC> withPriority(Integer priority) {
                this.priority = priority;
                return this;
            }

            @Override
            public Config<I, IC> parallelIf(Predicate<IC> predicate) {
                this.predicateForParallelIteration = predicate;
                return this;
            }

            Config<I, IC> setOutput(Object output) {
                this.output = output;
                return this;
            }

            @Override
            public Config<I, IC> taskBased() {
                this.iteratorSupplier = taskBasedIteratorSupplier;
                return this;
            }

            @Override
            public Config<I, IC> threadBased() {
                this.iteratorSupplier = threadBasedIteratorSupplier;
                return this;
            }

            @Override
            public <O, OC extends Collection<O>> IterableObjectHelper.IterationConfig.WithOutputOfCollection<I, IC, O, OC> withOutput(OC output) {
                return new IterableObjectHelper.IterationConfig.WithOutputOfCollection(this.setOutput(output));
            }

            @Override
            public <K, O, OM extends Map<K, O>> IterableObjectHelper.IterationConfig.WithOutputOfMap<I, IC, K, O, OM> withOutput(OM output) {
                return new IterableObjectHelper.IterationConfig.WithOutputOfMap(this.setOutput(output));
            }

            static abstract class WithOutput<I, IC, CWO extends WithOutput<I, IC, CWO>>
            implements IterableObjectHelper.IterationConfig<I, IC, CWO> {
                Config<I, IC> wrappedConfiguration;

                WithOutput(Config<I, IC> configuration) {
                    this.wrappedConfiguration = configuration;
                }

                @Override
                public CWO withAction(Consumer<I> action) {
                    this.wrappedConfiguration.withAction((Consumer)action);
                    return (CWO)this;
                }

                @Override
                public <O, OC extends Collection<O>> IterableObjectHelper.IterationConfig.WithOutputOfCollection<I, IC, O, OC> withOutput(OC output) {
                    this.wrappedConfiguration.setOutput(output);
                    return new IterableObjectHelper.IterationConfig.WithOutputOfCollection(this.wrappedConfiguration);
                }

                @Override
                public <K, O, OM extends Map<K, O>> IterableObjectHelper.IterationConfig.WithOutputOfMap<I, IC, K, O, OM> withOutput(OM output) {
                    this.wrappedConfiguration.setOutput(output);
                    return new IterableObjectHelper.IterationConfig.WithOutputOfMap(this.wrappedConfiguration);
                }

                @Override
                public CWO parallelIf(Predicate<IC> predicate) {
                    this.wrappedConfiguration.parallelIf((Predicate)predicate);
                    return (CWO)this;
                }

                @Override
                public CWO taskBased() {
                    this.wrappedConfiguration.taskBased();
                    return (CWO)this;
                }

                @Override
                public CWO threadBased() {
                    this.wrappedConfiguration.threadBased();
                    return (CWO)this;
                }

                @Override
                public CWO withPriority(Integer priority) {
                    this.wrappedConfiguration.withPriority(priority);
                    return (CWO)this;
                }

                Config<I, IC> getWrappedConfiguration() {
                    return this.wrappedConfiguration;
                }
            }
        }
    }
}

