/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.remote.messaging.karmaapi.common.JavaVM;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaAPI;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.KarmaSource;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.KarmaLogger;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.Level;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.LogCalendar;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.enums.LogExtension;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class Logger
extends KarmaLogger
implements Serializable {
    private static final Map<KarmaSource, LogCalendar> calendar_type = new ConcurrentHashMap<KarmaSource, LogCalendar>();
    private static final Map<KarmaSource, LogExtension> ext_type = new ConcurrentHashMap<KarmaSource, LogExtension>();
    private static final Map<KarmaSource, String> header = new ConcurrentHashMap<KarmaSource, String>();
    private static final Map<KarmaSource, Boolean> locked = new ConcurrentHashMap<KarmaSource, Boolean>();
    private final KarmaSource source;

    public Logger(@NotNull KarmaSource s) {
        super(s);
        this.source = s;
        header.put(this.source, "# System information<br>\n<br>\n" + StringUtils.formatString((CharSequence)"Os name: {0}<br>\n", JavaVM.osName()) + StringUtils.formatString((CharSequence)"Os version: {0}<br>\n", JavaVM.osVersion()) + StringUtils.formatString((CharSequence)"Os model: {0}<br>\n", JavaVM.osModel()) + StringUtils.formatString((CharSequence)"Os arch: {0}<br>\n", JavaVM.osArchitecture()) + StringUtils.formatString((CharSequence)"Os max memory: {0}<br>\n", JavaVM.osMaxMemory()) + StringUtils.formatString((CharSequence)"Os free memory: {0}<br>\n", JavaVM.osFreeMemory()) + "\n# VM information<br>\n<br>\n" + StringUtils.formatString((CharSequence)"Architecture: {0}<br>\n", JavaVM.jvmArchitecture()) + StringUtils.formatString((CharSequence)"Max memory: {0}<br>\n", JavaVM.jvmMax()) + StringUtils.formatString((CharSequence)"Free memory: {0}<br>\n", JavaVM.jvmAvailable()) + StringUtils.formatString((CharSequence)"Processors: {0}<br>\n", JavaVM.jvmProcessors()) + StringUtils.formatString((CharSequence)"Version: {0}<br>\n", JavaVM.javaVersion()) + "\n# API Information<br>\n" + StringUtils.formatString((CharSequence)"API Version: {0}<br>\n", KarmaAPI.getVersion()) + StringUtils.formatString((CharSequence)"API Compiler: {0}<br>\n", KarmaAPI.getCompilerVersion()) + StringUtils.formatString((CharSequence)"API Date: {0}<br>\n", KarmaAPI.getBuildDate()) + "\n# Source information<br>\n" + StringUtils.formatString((CharSequence)"Name: {0}<br>\n", this.source.name()) + StringUtils.formatString((CharSequence)"Version: {0}<br>\n", this.source.version()) + StringUtils.formatString((CharSequence)"Description: {0}<br>\n", this.source.description().replace("\n", "<br>")) + StringUtils.formatString((CharSequence)"Author(s): {0}<br>\n", this.source.authors(true, "<br>- ")) + StringUtils.formatString((CharSequence)"Update URL: {0}<br>\n", this.source.updateURL()) + "\n# Beginning of log<br><br>\n\n");
    }

    public Logger calendar(LogCalendar calendar) {
        calendar_type.put(this.source, calendar);
        return this;
    }

    public Logger extension(LogExtension extension) {
        ext_type.put(this.source, extension);
        return this;
    }

    @Override
    public void scheduleLog(@NotNull Level level, @NotNull CharSequence info, Object ... replaces) {
        this.source.async().queue(() -> this.logInfo(level, this.printInfo(), info, replaces));
    }

    @Override
    public void scheduleLog(@NotNull Level level, @NotNull Throwable error) {
        this.source.async().queue(() -> this.logError(level, this.printError(), error));
    }

    @Override
    public void scheduleLogOption(Level level, boolean print, CharSequence info, Object ... replaces) {
        this.source.async().queue(() -> this.logInfo(level, print, info, replaces));
    }

    @Override
    public void scheduleLogOption(Level level, boolean print, Throwable error) {
        this.source.async().queue(() -> this.logError(level, print, error));
    }

    @Override
    public void syncedLog(Level level, CharSequence info, Object ... replaces) {
        this.source.sync().queue(() -> this.logInfo(level, this.printInfo(), info, replaces));
    }

    @Override
    public void syncedLog(Level level, Throwable error) {
        this.source.sync().queue(() -> this.logError(level, this.printError(), error));
    }

    @Override
    public void syncedLogOption(Level level, boolean print, CharSequence info, Object ... replaces) {
        this.source.sync().queue(() -> this.logInfo(level, print, info, replaces));
    }

    @Override
    public void syncedLogOption(Level level, boolean print, Throwable error) {
        this.source.sync().queue(() -> this.logError(level, print, error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logInfo(Level level, boolean print, CharSequence info, Object ... replaces) {
        if (!locked.getOrDefault(this.source, false).booleanValue()) {
            Path log = this.getLoggerFile(ext_type.getOrDefault(this.source, LogExtension.MARKDOWN));
            String time = this.fetchTime(calendar_type.getOrDefault(this.source, LogCalendar.GREGORIAN));
            try {
                List<String> lines = this.removeHeader(Files.readAllLines(log));
                BufferedWriter writer = Files.newBufferedWriter(log, StandardCharsets.UTF_8, new OpenOption[0]);
                writer.write(header.get(this.source));
                for (String line : lines) {
                    writer.write(line + "\n");
                }
                writer.write(StringUtils.formatString((CharSequence)"[ {0} - {1} ] {2}<br>", level.name(), time, StringUtils.formatString(info, replaces)));
                writer.flush();
                writer.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            finally {
                if (print) {
                    this.source.console().send(info, level);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logError(Level level, boolean print, Throwable error) {
        Throwable prefix;
        if (locked.getOrDefault(this.source, false).booleanValue()) return;
        Path log = this.getLoggerFile(ext_type.getOrDefault(this.source, LogExtension.MARKDOWN));
        String time = this.fetchTime(calendar_type.getOrDefault(this.source, LogCalendar.GREGORIAN));
        try {
            List<String> lines = this.removeHeader(Files.readAllLines(log));
            BufferedWriter writer = Files.newBufferedWriter(log, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(header.get(this.source));
            for (String line : lines) {
                writer.write(line + "\n");
            }
            Throwable prefix2 = new Throwable(error);
            writer.write(StringUtils.formatString((CharSequence)"[ {0} - {1} ] {2}\n", level.name(), time, prefix2.fillInStackTrace()));
            writer.write("```java\n");
            for (StackTraceElement element : error.getStackTrace()) {
                writer.write(element + "\n");
            }
            writer.write("```");
            writer.flush();
            writer.close();
            prefix = new Throwable(error);
            if (!print) return;
        }
        catch (Throwable ex) {
            Throwable prefix3;
            try {
                ex.printStackTrace();
                prefix3 = new Throwable(error);
                if (!print) return;
            }
            catch (Throwable throwable) {
                Throwable prefix4 = new Throwable(error);
                if (!print) throw throwable;
                this.source.console().send((CharSequence)"An internal error occurred ( {0} )", level, prefix4.fillInStackTrace());
                for (StackTraceElement element : error.getStackTrace()) {
                    this.source.console().send((CharSequence)element.toString(), Level.INFO);
                }
                throw throwable;
            }
            this.source.console().send((CharSequence)"An internal error occurred ( {0} )", level, prefix3.fillInStackTrace());
            for (StackTraceElement element : error.getStackTrace()) {
                this.source.console().send((CharSequence)element.toString(), Level.INFO);
            }
            return;
        }
        this.source.console().send((CharSequence)"An internal error occurred ( {0} )", level, prefix.fillInStackTrace());
        for (StackTraceElement element : error.getStackTrace()) {
            this.source.console().send((CharSequence)element.toString(), Level.INFO);
        }
        return;
    }

    @Override
    public synchronized void clearLog() throws IllegalStateException {
        locked.put(this.source, true);
        this.source.async().queue(() -> {
            Path logFile = this.getLoggerFile(ext_type.getOrDefault(this.source, LogExtension.MARKDOWN));
            try {
                BufferedWriter writer = Files.newBufferedWriter(logFile, StandardCharsets.UTF_8, new OpenOption[0]);
                writer.write("");
                writer.flush();
                writer.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Failed to clear log file ");
            }
            finally {
                locked.remove(this.source);
            }
        });
    }

    @Override
    public boolean flush() {
        return true;
    }

    private List<String> removeHeader(List<String> lines) {
        ArrayList<String> copy = new ArrayList<String>();
        boolean begone = false;
        for (String line : lines) {
            if (begone) {
                copy.add(line);
                continue;
            }
            if (!line.startsWith("# Beginning of log<br><br>")) continue;
            begone = true;
        }
        if (copy.size() > 1 && StringUtils.isNullOrEmpty(copy.get(0)) && StringUtils.isNullOrEmpty(copy.get(1))) {
            copy.remove(0);
        }
        return copy;
    }
}

