/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaArray;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaElement;
import ml.karmaconfigs.remote.messaging.karmaapi.common.karma.file.element.KarmaObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaKeyArray
extends KarmaElement
implements Iterable<KarmaElement>,
Iterator<String> {
    private int current = 0;
    private final Map<String, KarmaElement> elements = new LinkedHashMap<String, KarmaElement>();
    private final Map<KarmaElement, String> reverse = new LinkedHashMap<KarmaElement, String>();

    public void add(String key, KarmaElement element, boolean recursively) {
        this.elements.put(key, element);
        if (recursively) {
            this.reverse.put(element, key);
        }
    }

    public void remove(String ... key) {
        for (String k : key) {
            KarmaElement element;
            if (!this.elements.containsKey(k) || (element = this.elements.remove(k)) == null) continue;
            this.reverse.remove(element);
        }
    }

    public void remove(KarmaElement ... element) {
        for (KarmaElement e : element) {
            String key;
            if (!this.reverse.containsKey(e) || (key = this.reverse.remove(e)) == null) continue;
            this.elements.remove(key);
        }
    }

    public boolean contains(KarmaElement ... element) {
        HashSet<String> strings = new HashSet<String>();
        HashSet<Number> numbers = new HashSet<Number>();
        HashSet<Boolean> booleans = new HashSet<Boolean>();
        for (KarmaElement item : this.elements.values()) {
            if (!item.isArray() && !item.isKeyArray()) {
                KarmaObject obj = item.getObjet();
                if (obj.isString()) {
                    strings.add(obj.toString());
                }
                if (obj.isNumber()) {
                    numbers.add(obj.getNumber());
                }
                if (!obj.isBoolean()) continue;
                booleans.add(obj.getBoolean());
                continue;
            }
            this.fill(item, strings, numbers, booleans);
        }
        for (KarmaElement check : element) {
            boolean bool;
            Number number;
            String str;
            if (!check.isValid() || !(check instanceof KarmaObject)) continue;
            KarmaObject obj = check.getObjet();
            if (check.isString() && strings.contains(str = obj.getString())) {
                return true;
            }
            if (check.isNumber() && numbers.contains(number = obj.getNumber())) {
                return true;
            }
            if (!check.isBoolean() || !booleans.contains(bool = obj.getBoolean().booleanValue())) continue;
            return true;
        }
        return false;
    }

    public KarmaElement containsAny(KarmaElement ... element) {
        HashSet<String> strings = new HashSet<String>();
        HashSet<Number> numbers = new HashSet<Number>();
        HashSet<Boolean> booleans = new HashSet<Boolean>();
        for (KarmaElement item : this.elements.values()) {
            if (!item.isArray() && !item.isKeyArray()) {
                KarmaObject obj = item.getObjet();
                if (obj.isString()) {
                    strings.add(obj.toString());
                }
                if (obj.isNumber()) {
                    numbers.add(obj.getNumber());
                }
                if (!obj.isBoolean()) continue;
                booleans.add(obj.getBoolean());
                continue;
            }
            this.fill(item, strings, numbers, booleans);
        }
        for (KarmaElement check : element) {
            boolean bool;
            Number number;
            String str;
            if (!check.isValid() || !(check instanceof KarmaObject)) continue;
            KarmaObject obj = check.getObjet();
            if (check.isString() && strings.contains(str = obj.getString())) {
                return check;
            }
            if (check.isNumber() && numbers.contains(number = obj.getNumber())) {
                return check;
            }
            if (!check.isBoolean() || !booleans.contains(bool = obj.getBoolean().booleanValue())) continue;
            return check;
        }
        return null;
    }

    public boolean containsAll(KarmaElement ... element) {
        HashSet<String> strings = new HashSet<String>();
        HashSet<Number> numbers = new HashSet<Number>();
        HashSet<Boolean> booleans = new HashSet<Boolean>();
        for (KarmaElement item : this.elements.values()) {
            if (!item.isArray() && !item.isKeyArray()) {
                KarmaObject obj = item.getObjet();
                if (obj.isString()) {
                    strings.add(obj.toString());
                }
                if (obj.isNumber()) {
                    numbers.add(obj.getNumber());
                }
                if (!obj.isBoolean()) continue;
                booleans.add(obj.getBoolean());
                continue;
            }
            this.fill(item, strings, numbers, booleans);
        }
        for (KarmaElement check : element) {
            boolean bool;
            Number number;
            String str;
            if (!check.isValid() || !(check instanceof KarmaObject)) continue;
            KarmaObject obj = check.getObjet();
            if (check.isString() && !strings.contains(str = obj.getString())) {
                return false;
            }
            if (check.isNumber() && !numbers.contains(number = obj.getNumber())) {
                return false;
            }
            if (!check.isBoolean() || booleans.contains(bool = obj.getBoolean().booleanValue())) continue;
            return false;
        }
        return true;
    }

    public final KarmaElement get(int index) {
        int curr = 0;
        for (KarmaElement element : this.elements.values()) {
            if (++curr != index && curr != this.elements.size()) continue;
            return element;
        }
        return null;
    }

    public final KarmaElement get(String key) {
        return this.elements.getOrDefault(key, null);
    }

    public final String get(KarmaElement element) {
        return this.reverse.getOrDefault(element, null);
    }

    public final Set<String> getKeys() {
        return new LinkedHashSet<String>(this.elements.keySet());
    }

    public boolean isRecursive(String key) {
        KarmaElement element = this.elements.getOrDefault(key, null);
        if (element != null) {
            String tmp = this.reverse.getOrDefault(element, null);
            return tmp.equals(key);
        }
        return false;
    }

    public boolean isRecursive(KarmaElement element) {
        String key = this.reverse.getOrDefault(element, null);
        if (key != null) {
            KarmaElement tmp = this.elements.getOrDefault(key, null);
            return tmp == element;
        }
        return false;
    }

    @Override
    public final boolean hasNext() {
        return this.current < this.elements.size();
    }

    @Override
    @Nullable
    public final String next() {
        int index = 0;
        for (String str : this.elements.keySet()) {
            if (++index != this.current + 1) continue;
            this.current = index;
            return str;
        }
        return null;
    }

    @Override
    public final KarmaElement toLowerCase() {
        LinkedHashSet<KarmaElement> result = new LinkedHashSet<KarmaElement>();
        for (KarmaElement current : this.elements.values()) {
            KarmaElement tmp;
            if (!current.isArray() && !current.isKeyArray()) {
                KarmaObject object = current.getObjet();
                tmp = object.toLowerCase();
            } else if (current.isArray()) {
                KarmaArray ar = current.getArray();
                tmp = ar.toLowerCase();
            } else {
                KarmaKeyArray ark = current.getKeyArray();
                tmp = ark.toLowerCase();
            }
            result.add(tmp);
        }
        return new KarmaArray(result.toArray(new KarmaElement[0]));
    }

    @Override
    public final KarmaElement toUpperCase() {
        LinkedHashSet<KarmaElement> result = new LinkedHashSet<KarmaElement>();
        for (KarmaElement current : this.elements.values()) {
            KarmaElement tmp;
            if (!current.isArray() && !current.isKeyArray()) {
                KarmaObject object = current.getObjet();
                tmp = object.toUpperCase();
            } else if (current.isArray()) {
                KarmaArray ar = current.getArray();
                tmp = ar.toUpperCase();
            } else {
                KarmaKeyArray ark = current.getKeyArray();
                tmp = ark.toUpperCase();
            }
            result.add(tmp);
        }
        return new KarmaArray(result.toArray(new KarmaElement[0]));
    }

    @Override
    @NotNull
    public final Iterator<KarmaElement> iterator() {
        return new LinkedHashSet<KarmaElement>(this.elements.values()).iterator();
    }

    @Override
    public final KarmaElement copy() {
        KarmaKeyArray key = new KarmaKeyArray();
        for (String str : this.elements.keySet()) {
            key.add(str, this.elements.getOrDefault(str, null), this.isRecursive(str));
        }
        return key;
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final boolean isKeyArray() {
        return false;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isBoolean() {
        return false;
    }

    @Override
    public final boolean isValid() {
        for (KarmaElement element : this.elements.values()) {
            if (element != null) continue;
            return false;
        }
        for (String key : this.reverse.values()) {
            if (key != null) continue;
            return false;
        }
        return true;
    }

    private void fill(KarmaElement array, Set<String> strings, Set<Number> numbers, Set<Boolean> booleans) {
        if (array instanceof KarmaArray) {
            KarmaArray r = (KarmaArray)array;
            r.forEach(item -> {
                if (!item.isArray() && !item.isKeyArray()) {
                    KarmaObject obj = item.getObjet();
                    if (obj.isString()) {
                        strings.add(obj.toString());
                    }
                    if (obj.isNumber()) {
                        numbers.add(obj.getNumber());
                    }
                    if (obj.isBoolean()) {
                        booleans.add(obj.getBoolean());
                    }
                } else {
                    this.fill((KarmaElement)item, strings, numbers, booleans);
                }
            });
        }
        if (array instanceof KarmaKeyArray) {
            KarmaKeyArray rk = (KarmaKeyArray)array;
            rk.forEach(item -> {
                if (!item.isArray() && !item.isKeyArray()) {
                    KarmaObject obj = item.getObjet();
                    if (obj.isString()) {
                        strings.add(obj.toString());
                    }
                    if (obj.isNumber()) {
                        numbers.add(obj.getNumber());
                    }
                    if (obj.isBoolean()) {
                        booleans.add(obj.getBoolean());
                    }
                } else {
                    this.fill((KarmaElement)item, strings, numbers, booleans);
                }
            });
        }
    }
}

