/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.remote.messaging.util.message;

import java.io.Serializable;
import java.util.Base64;
import java.util.Set;
import ml.karmaconfigs.remote.messaging.karmaapi.common.utils.string.StringUtils;
import ml.karmaconfigs.remote.messaging.util.message.type.DataType;
import ml.karmaconfigs.remote.messaging.util.message.type.MergeType;
import org.jetbrains.annotations.Nullable;

public abstract class MessageOutput
implements Serializable {
    private final MergeType type;
    private final MessageOutput origin;

    public MessageOutput() {
        this.type = MergeType.NONE;
        this.origin = null;
    }

    public MessageOutput(@Nullable MessageOutput merge, MergeType mt) {
        this.origin = merge;
        this.type = mt;
    }

    public MessageOutput(byte[] merge, MergeType mt) {
        String serialized = new String(Base64.getDecoder().decode(merge));
        this.origin = (MessageOutput)StringUtils.loadUnsafe(serialized);
        this.type = mt;
    }

    public abstract void writeSerializable(String var1, Serializable var2);

    public abstract void write(String var1, CharSequence var2);

    public abstract void write(String var1, boolean var2);

    public abstract void write(String var1, Number var2);

    public abstract void write(String var1, char ... var2);

    public abstract void write(String var1, byte[] var2);

    public abstract <T> void unsafeWrite(String var1, T var2, DataType var3);

    public abstract void remove(String var1, DataType var2);

    public abstract Set<String> getKeys(DataType var1);

    public abstract boolean contains(String var1, DataType var2);

    @Nullable
    abstract <T> T get(String var1, DataType var2);

    public abstract byte[] compile();

    MergeType merge() {
        return this.type;
    }

    @Nullable
    MessageOutput affiliate() {
        return this.origin;
    }
}

