/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.audio.producer;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import ml.miron.captcha.audio.Sample;
import ml.miron.captcha.audio.producer.VoiceProducer;
import ml.miron.captcha.util.FileUtil;

public class NumberVoiceProducer
implements VoiceProducer {
    private static final Random RAND = new SecureRandom();
    private static final String[] DEFAULT_VOICES = new String[]{"alex", "bruce", "fred", "ralph", "kathy", "vicki", "victoria"};
    private static final Map<Integer, String[]> DEFAULT_VOICES_MAP = new HashMap<Integer, String[]>();
    private final Map<Integer, String[]> voices;

    public NumberVoiceProducer() {
        this(DEFAULT_VOICES_MAP);
    }

    public NumberVoiceProducer(Map<Integer, String[]> voices) {
        this.voices = voices;
    }

    @Override
    public final Sample getVocalization(char num) {
        if (!Character.isDigit(num)) {
            throw new IllegalArgumentException("Expected <num> to be a number, got '" + num + "' instead.");
        }
        int idx = Integer.parseInt(num + "");
        String[] files = this.voices.get(idx);
        String filename = files[RAND.nextInt(files.length)];
        return FileUtil.readSample(filename);
    }

    static {
        for (int i = 0; i < 10; ++i) {
            String[] filesForNum = new String[DEFAULT_VOICES.length];
            for (int j = 0; j < filesForNum.length; ++j) {
                StringBuilder sb = new StringBuilder("/META-INF/resources/smartcaptcha/sounds/en/numbers/");
                sb.append(i);
                sb.append("-");
                sb.append(DEFAULT_VOICES[j]);
                sb.append(".wav");
                filesForNum[j] = sb.toString();
            }
            DEFAULT_VOICES_MAP.put(i, filesForNum);
        }
    }
}

