/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.audio.producer;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import ml.miron.captcha.audio.Sample;
import ml.miron.captcha.audio.producer.NoiseProducer;
import ml.miron.captcha.util.FileUtil;
import ml.miron.captcha.util.MixerUtil;

public class RandomNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new SecureRandom();
    private static final String[] DEFAULT_NOISES = new String[]{"/META-INF/resources/smartcaptcha/sounds/sounds/noises/radio_tuning.wav", "/META-INF/resources/smartcaptcha/sounds/sounds/noises/restaurant.wav", "/META-INF/resources/smartcaptcha/sounds/sounds/noises/swimming.wav"};
    private final String[] noiseFiles;

    public RandomNoiseProducer() {
        this(DEFAULT_NOISES);
    }

    public RandomNoiseProducer(String[] noiseFiles) {
        this.noiseFiles = (String[])noiseFiles.clone();
    }

    @Override
    public Sample addNoise(List<Sample> samples) {
        Sample appended = MixerUtil.append(samples);
        String noiseFile = this.noiseFiles[RAND.nextInt(this.noiseFiles.length)];
        Sample noise = FileUtil.readSample(noiseFile);
        return MixerUtil.mix(appended, 1.0, noise, 0.6);
    }
}

