/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import javax.imageio.ImageIO;
import ml.miron.captcha.image.background.Background;
import ml.miron.captcha.image.background.TransparentBackground;
import ml.miron.captcha.image.producer.CurvedLineNoiseProducer;
import ml.miron.captcha.image.producer.DefaultTextProducer;
import ml.miron.captcha.image.producer.NoiseProducer;
import ml.miron.captcha.image.producer.TextProducer;
import ml.miron.captcha.image.renderer.DefaultWordRenderer;
import ml.miron.captcha.image.renderer.FishEyeRenderer;
import ml.miron.captcha.image.renderer.Renderer;
import ml.miron.captcha.image.renderer.WordRenderer;

public final class Captcha {
    private final Builder builder;

    private Captcha(Builder builder) {
        this.builder = builder;
    }

    public boolean isCorrect(String answer) {
        return answer.equals(this.builder.answer);
    }

    public String getAnswer() {
        return this.builder.answer;
    }

    public BufferedImage getImage() {
        return this.builder.img;
    }

    public static class Builder {
        private String answer = "";
        private BufferedImage img;
        private BufferedImage bg;
        private Date timeStamp;
        private boolean addBorder = false;

        public Builder(int width, int height) {
            this.img = new BufferedImage(width, height, 2);
        }

        public Builder addBackground() {
            return this.addBackground(new TransparentBackground());
        }

        public Builder addBackground(Background background) {
            this.bg = background.getBackground(this.img.getWidth(), this.img.getHeight());
            return this;
        }

        public Builder addText(WordRenderer wordRenderer) {
            return this.addText(new DefaultTextProducer(), wordRenderer);
        }

        public Builder addText() {
            return this.addText(new DefaultTextProducer());
        }

        public Builder addText(TextProducer txtProd) {
            return this.addText(txtProd, new DefaultWordRenderer());
        }

        public Builder addText(TextProducer txtProd, WordRenderer wRenderer) {
            this.answer = this.answer + txtProd.getText();
            wRenderer.render(this.answer, this.img);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new CurvedLineNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noise) {
            noise.makeNoise(this.img);
            return this;
        }

        public Builder gimp() {
            return this.gimp(new FishEyeRenderer());
        }

        public Builder gimp(Renderer renderer) {
            renderer.gimp(this.img);
            return this;
        }

        public Builder addBorder() {
            this.addBorder = true;
            return this;
        }

        public Captcha build() {
            if (this.bg == null) {
                this.bg = new TransparentBackground().getBackground(this.img.getWidth(), this.img.getHeight());
            }
            Graphics2D g = this.bg.createGraphics();
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.drawImage(this.img, null, null);
            if (this.addBorder) {
                int width = this.img.getWidth();
                int height = this.img.getHeight();
                g.setColor(Color.BLACK);
                g.drawLine(0, 0, 0, width);
                g.drawLine(0, 0, width, 0);
                g.drawLine(0, height - 1, width, height - 1);
                g.drawLine(width - 1, height - 1, width - 1, 0);
            }
            this.img = this.bg;
            this.timeStamp = new Date();
            return new Captcha(this);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.answer);
            out.writeObject(this.timeStamp);
            ImageIO.write((RenderedImage)this.img, "png", ImageIO.createImageOutputStream(out));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.answer = (String)in.readObject();
            this.timeStamp = (Date)in.readObject();
            this.img = ImageIO.read(ImageIO.createImageInputStream(in));
        }
    }
}

