/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.servlet;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ml.miron.captcha.image.Captcha;
import ml.miron.captcha.image.background.GradiatedBackground;
import ml.miron.captcha.image.producer.DefaultTextProducer;
import ml.miron.captcha.image.producer.NumbersAnswerProducer;
import ml.miron.captcha.image.renderer.ColoredEdgesWordRenderer;
import ml.miron.captcha.util.CaptchaServletUtil;

public class CaptchaServlet
extends HttpServlet
implements SingleThreadModel {
    private static final List<Color> COLORS = new ArrayList<Color>();
    private static final List<Font> FONTS = new ArrayList<Font>();
    private int width = 200;
    private int height = 50;

    public void init() throws ServletException {
        if (this.getInitParameter("captcha-height") != null) {
            this.height = Integer.parseInt(this.getInitParameter("captcha-height"));
        }
        if (this.getInitParameter("captcha-width") != null) {
            this.width = Integer.parseInt(this.getInitParameter("captcha-width"));
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ColoredEdgesWordRenderer wordRenderer = new ColoredEdgesWordRenderer(COLORS, FONTS);
        Captcha.Builder builder = new Captcha.Builder(this.width, this.height).gimp().addNoise().addBackground(new GradiatedBackground());
        String answer = (String)req.getSession().getAttribute("CAPTCHA");
        if (answer != null) {
            builder.addText(new DefaultTextProducer(answer), wordRenderer);
        } else {
            builder.addText(new NumbersAnswerProducer(), wordRenderer);
        }
        Captcha captcha = builder.build();
        req.getSession().setAttribute("CAPTCHA", (Object)captcha.getAnswer());
        CaptchaServletUtil.writeImage(resp, captcha.getImage());
    }

    static {
        COLORS.add(Color.BLUE);
        COLORS.add(Color.RED);
        COLORS.add(Color.GREEN);
        FONTS.add(new Font("Geneva", 2, 48));
        FONTS.add(new Font("Courier", 1, 48));
        FONTS.add(new Font("Arial", 1, 48));
    }
}

