/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import ml.miron.captcha.audio.Sample;

public final class FileUtil {
    private static final Logger LOG = Logger.getLogger(FileUtil.class.getName());

    private FileUtil() {
    }

    public static InputStream readResource(String filename) {
        InputStream jarIs = FileUtil.class.getResourceAsStream(filename);
        if (jarIs == null) {
            throw new IllegalStateException(new FileNotFoundException("File '" + filename + "' not found."));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        try {
            int nRead;
            while ((nRead = jarIs.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            jarIs.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not read file: ", e);
        }
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    public static Sample readSample(String filename) {
        InputStream is = FileUtil.readResource(filename);
        return new Sample(is);
    }
}

