/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.audio;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import ml.miron.captcha.audio.Sample;
import ml.miron.captcha.audio.producer.NoiseProducer;
import ml.miron.captcha.audio.producer.NumberVoiceProducer;
import ml.miron.captcha.audio.producer.RandomNoiseProducer;
import ml.miron.captcha.audio.producer.VoiceProducer;
import ml.miron.captcha.image.producer.NumbersAnswerProducer;
import ml.miron.captcha.image.producer.TextProducer;
import ml.miron.captcha.util.MixerUtil;

public final class AudioCaptcha {
    private static final Random RAND = new SecureRandom();
    private final Builder builder;

    private AudioCaptcha(Builder builder) {
        this.builder = builder;
    }

    public boolean isCorrect(String answer) {
        return answer.equals(this.builder.answer);
    }

    public String getAnswer() {
        return this.builder.answer;
    }

    public Sample getChallenge() {
        return this.builder.challenge;
    }

    public static class Builder {
        private String answer = "";
        private Sample challenge;
        private List<VoiceProducer> voiceProds = new ArrayList<VoiceProducer>();
        private List<NoiseProducer> noiseProds = new ArrayList<NoiseProducer>();

        public Builder addAnswer() {
            return this.addAnswer(new NumbersAnswerProducer());
        }

        public Builder addAnswer(TextProducer ansProd) {
            this.answer = this.answer + ansProd.getText();
            return this;
        }

        public Builder addVoice() {
            this.voiceProds.add(new NumberVoiceProducer());
            return this;
        }

        public Builder addVoice(VoiceProducer vProd) {
            this.voiceProds.add(vProd);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new RandomNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noiseProd) {
            this.noiseProds.add(noiseProd);
            return this;
        }

        public AudioCaptcha build() {
            if (this.voiceProds.isEmpty()) {
                this.addVoice();
            }
            char[] answerArray = this.answer.toCharArray();
            ArrayList<Sample> samples = new ArrayList<Sample>();
            for (char c : answerArray) {
                VoiceProducer vProd = this.voiceProds.get(RAND.nextInt(this.voiceProds.size()));
                Sample sample = vProd.getVocalization(c);
                samples.add(sample);
            }
            if (this.noiseProds.isEmpty()) {
                NoiseProducer nProd = this.noiseProds.get(RAND.nextInt(this.noiseProds.size()));
                this.challenge = nProd.addNoise(samples);
                return new AudioCaptcha(this);
            }
            this.challenge = MixerUtil.append(samples);
            return new AudioCaptcha(this);
        }
    }
}

