/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import ml.miron.captcha.image.background.Background;
import ml.miron.captcha.image.background.TransparentBackground;
import ml.miron.captcha.image.producer.CurvedLineNoiseProducer;
import ml.miron.captcha.image.producer.DefaultTextProducer;
import ml.miron.captcha.image.producer.NoiseProducer;
import ml.miron.captcha.image.producer.TextProducer;
import ml.miron.captcha.image.renderer.DefaultWordRenderer;
import ml.miron.captcha.image.renderer.FishEyeRenderer;
import ml.miron.captcha.image.renderer.Renderer;
import ml.miron.captcha.image.renderer.WordRenderer;

public final class Captcha {
    private final Builder builder;

    private Captcha(Builder builder) {
        this.builder = builder;
    }

    public boolean isCorrect(String answer) {
        return answer.equals(this.builder.answer);
    }

    public String getAnswer() {
        return this.builder.answer;
    }

    public BufferedImage getImage() {
        return this.builder.image;
    }

    public static class Builder {
        private String answer = "";
        private BufferedImage image;
        private BufferedImage background;
        private boolean addBorder = false;

        public Builder(int width, int height) {
            this.image = new BufferedImage(width, height, 2);
        }

        public Builder addBackground() {
            return this.addBackground(new TransparentBackground());
        }

        public Builder addBackground(Background background) {
            this.background = background.getBackground(this.image.getWidth(), this.image.getHeight());
            return this;
        }

        public Builder addText(WordRenderer wordRenderer) {
            return this.addText(new DefaultTextProducer(), wordRenderer);
        }

        public Builder addText() {
            return this.addText(new DefaultTextProducer());
        }

        public Builder addText(TextProducer txtProd) {
            return this.addText(txtProd, new DefaultWordRenderer());
        }

        public Builder addText(TextProducer txtProd, WordRenderer wRenderer) {
            this.answer = this.answer + txtProd.getText();
            wRenderer.render(this.answer, this.image);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new CurvedLineNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noise) {
            noise.makeNoise(this.image);
            return this;
        }

        public Builder gimp() {
            return this.gimp(new FishEyeRenderer());
        }

        public Builder gimp(Renderer renderer) {
            renderer.gimp(this.image);
            return this;
        }

        public Builder addBorder() {
            this.addBorder = true;
            return this;
        }

        public Captcha build() {
            if (this.background == null) {
                this.background = new TransparentBackground().getBackground(this.image.getWidth(), this.image.getHeight());
            }
            Graphics2D g = this.background.createGraphics();
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.drawImage(this.image, null, null);
            if (this.addBorder) {
                int width = this.image.getWidth();
                int height = this.image.getHeight();
                g.setColor(Color.BLACK);
                g.drawLine(0, 0, 0, width);
                g.drawLine(0, 0, width, 0);
                g.drawLine(0, height - 1, width, height - 1);
                g.drawLine(width - 1, height - 1, width - 1, 0);
            }
            this.image = this.background;
            return new Captcha(this);
        }
    }
}

