/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.image.producer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.Random;
import ml.miron.captcha.image.producer.NoiseProducer;

public class CurvedLineNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new SecureRandom();
    private final Color color;
    private final float width;

    public CurvedLineNoiseProducer() {
        this(Color.BLACK, 3.0f);
    }

    public CurvedLineNoiseProducer(Color color, float width) {
        this.color = color;
        this.width = width;
    }

    @Override
    public void makeNoise(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        CubicCurve2D.Float cc = new CubicCurve2D.Float((float)imageWidth * 0.1f, (float)imageHeight * RAND.nextFloat(), (float)imageWidth * 0.1f, (float)imageHeight * RAND.nextFloat(), (float)imageWidth * 0.25f, (float)imageHeight * RAND.nextFloat(), (float)imageWidth * 0.9f, (float)imageHeight * RAND.nextFloat());
        PathIterator pi = cc.getPathIterator(null, 2.0);
        Point2D[] tmp = new Point2D[200];
        int i = 0;
        while (!pi.isDone()) {
            float[] coords = new float[6];
            int i1 = pi.currentSegment(coords);
            if (i1 == 0 || i1 == 1) {
                tmp[i] = new Point2D.Float(coords[0], coords[1]);
            }
            ++i;
            pi.next();
        }
        Point2D[] pts = new Point2D[i];
        System.arraycopy(tmp, 0, pts, 0, i);
        Graphics2D graph = (Graphics2D)image.getGraphics();
        graph.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graph.setColor(this.color);
        for (i = 0; i < pts.length - 1; ++i) {
            if (i < 3) {
                graph.setStroke(new BasicStroke(this.width));
            }
            graph.drawLine((int)pts[i].getX(), (int)pts[i].getY(), (int)pts[i + 1].getX(), (int)pts[i + 1].getY());
        }
        graph.dispose();
    }
}

