/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.image.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import ml.miron.captcha.image.renderer.WordRenderer;

public class ColoredEdgesWordRenderer
implements WordRenderer {
    private static final Random RAND = new SecureRandom();
    private static final List<Color> DEFAULT_COLORS = new ArrayList<Color>();
    private static final List<Font> DEFAULT_FONTS = new ArrayList<Font>();
    private static final float DEFAULT_STROKE_WIDTH = 1.0f;
    private static final double YOFFSET = 0.25;
    private static final double XOFFSET = 0.05;
    private final List<Font> fonts;
    private final List<Color> colors;
    private final float strokeWidth;

    public ColoredEdgesWordRenderer() {
        this(DEFAULT_COLORS, DEFAULT_FONTS, 1.0f);
    }

    public ColoredEdgesWordRenderer(List<Color> colors, List<Font> fonts) {
        this(colors, fonts, 1.0f);
    }

    public ColoredEdgesWordRenderer(List<Color> colors, List<Font> fonts, float strokeWidth) {
        this.colors = colors != null ? colors : DEFAULT_COLORS;
        this.fonts = fonts != null ? fonts : DEFAULT_FONTS;
        this.strokeWidth = strokeWidth < 0.0f ? 1.0f : strokeWidth;
    }

    @Override
    public void render(String word, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g.setRenderingHints(hints);
        AttributedString as = new AttributedString(word);
        as.addAttribute(TextAttribute.FONT, this.getRandomFont());
        FontRenderContext frc = g.getFontRenderContext();
        AttributedCharacterIterator aci = as.getIterator();
        TextLayout tl = new TextLayout(aci, frc);
        int xBaseline = (int)Math.round((double)image.getWidth() * 0.05);
        int yBaseline = image.getHeight() - (int)Math.round((double)image.getHeight() * 0.25);
        Shape shape = tl.getOutline(AffineTransform.getTranslateInstance(xBaseline, yBaseline));
        g.setColor(this.getRandomColor());
        g.setStroke(new BasicStroke(this.strokeWidth));
        g.draw(shape);
    }

    private Color getRandomColor() {
        return (Color)this.getRandomObject(this.colors);
    }

    private Font getRandomFont() {
        return (Font)this.getRandomObject(this.fonts);
    }

    private Object getRandomObject(List<?> objs) {
        if (objs.size() == 1) {
            return objs.get(0);
        }
        int i = RAND.nextInt(objs.size());
        return objs.get(i);
    }

    static {
        DEFAULT_FONTS.add(new Font("Arial", 1, 40));
        DEFAULT_COLORS.add(Color.BLACK);
    }
}

