/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import ml.miron.captcha.audio.Sample;

public final class CaptchaServletUtil {
    private static final Logger LOG = Logger.getLogger(CaptchaServletUtil.class.getName());
    private static final int AUDIO_STREAM_SIZE = 1024;
    public static final String CAPTCHA_ATTRIBUTE = "CAPTCHA";

    private CaptchaServletUtil() {
    }

    public static void writeImage(HttpServletResponse response, BufferedImage image) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("image/png");
        try {
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "png", (OutputStream)os);
            os.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not write image to response: ", e);
        }
    }

    public static void writeAudio(HttpServletResponse response, Sample sample) {
        response.setHeader("Cache-Control", "private,no-cache,no-store");
        response.setContentType("audio/wav");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            AudioSystem.write(sample.getAudioInputStream(), AudioFileFormat.Type.WAVE, baos);
            response.setContentLength(baos.size());
            ServletOutputStream os = response.getOutputStream();
            os.write(baos.toByteArray());
            os.flush();
            os.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not write audio to response: ", e);
        }
    }
}

