/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.audio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sample {
    private static final Logger LOG = Logger.getLogger(Sample.class.getName());
    public static final AudioFormat SC_AUDIO_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
    private final AudioInputStream audioInputStream;

    public Sample(InputStream is) {
        if (is instanceof AudioInputStream) {
            this.audioInputStream = (AudioInputStream)is;
            return;
        }
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(is);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new IllegalStateException(e);
        }
        Sample.checkFormat(this.audioInputStream.getFormat());
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioInputStream;
    }

    public AudioFormat getFormat() {
        return this.audioInputStream.getFormat();
    }

    public long getSampleCount() {
        long total = this.audioInputStream.getFrameLength() * (long)this.getFormat().getFrameSize() * 8L / (long)this.getFormat().getSampleSizeInBits();
        return total / (long)this.getFormat().getChannels();
    }

    public double[] getInterleavedSamples() {
        double[] samples = new double[(int)this.getSampleCount()];
        try {
            this.getInterleavedSamples(0L, this.getSampleCount(), samples);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not get interleaved samples: ", e);
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.SEVERE, "Could not get interleaved samples: ", e);
        }
        return samples;
    }

    public double[] getInterleavedSamples(long begin, long end, double[] samples) throws IOException {
        int nRead;
        long nbSamples = end - begin;
        long nbBytes = nbSamples * (long)(this.getFormat().getSampleSizeInBits() / 8) * (long)this.getFormat().getChannels();
        if (nbBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many samples. Try using a smaller wav.");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] inBuffer = new byte[(int)nbBytes];
        while ((nRead = this.audioInputStream.read(inBuffer, 0, inBuffer.length)) != -1) {
            buffer.write(inBuffer, 0, nRead);
        }
        buffer.flush();
        this.decodeBytes(buffer.toByteArray(), samples);
        return samples;
    }

    public void getChannelSamples(int channel, double[] interleavedSamples, double[] channelSamples) {
        int nbChannels = this.getFormat().getChannels();
        for (int i = 0; i < channelSamples.length; ++i) {
            channelSamples[i] = interleavedSamples[nbChannels * i + channel];
        }
    }

    public void getStereoSamples(double[] leftSamples, double[] rightSamples) throws IOException {
        long sampleCount = this.getSampleCount();
        double[] interleavedSamples = new double[(int)sampleCount * 2];
        this.getInterleavedSamples(0L, sampleCount, interleavedSamples);
        for (int i = 0; i < leftSamples.length; ++i) {
            leftSamples[i] = interleavedSamples[2 * i];
            rightSamples[i] = interleavedSamples[2 * i + 1];
        }
    }

    public void decodeBytes(byte[] audioBytes, double[] audioSamples) {
        int sampleSizeInBytes = this.getFormat().getSampleSizeInBits() / 8;
        int[] sampleBytes = new int[sampleSizeInBytes];
        int k = 0;
        for (int i = 0; i < audioSamples.length; ++i) {
            double val;
            int j;
            if (this.getFormat().isBigEndian()) {
                for (j = 0; j < sampleSizeInBytes; ++j) {
                    sampleBytes[j] = audioBytes[k++];
                }
            } else {
                for (j = sampleSizeInBytes - 1; j >= 0; --j) {
                    sampleBytes[j] = audioBytes[k++];
                }
            }
            int ival = 0;
            for (int j2 = 0; j2 < sampleSizeInBytes; ++j2) {
                ival += sampleBytes[j2];
                if (j2 >= sampleSizeInBytes - 1) continue;
                ival <<= 8;
            }
            double ratio = Math.pow(2.0, this.getFormat().getSampleSizeInBits() - 1);
            audioSamples[i] = val = (double)ival / ratio;
        }
    }

    public final byte[] asByteArray() {
        return Sample.asByteArray(this.getSampleCount(), this.getInterleavedSamples());
    }

    public static byte[] asByteArray(long sampleCount, double[] sample) {
        int bufferLength = (int)sampleCount * (SC_AUDIO_FORMAT.getSampleSizeInBits() / 8);
        byte[] buffer = new byte[bufferLength];
        for (int i = 0; i < sample.length; ++i) {
            int in = (int)(sample[i] * 32767.0);
            buffer[2 * i] = (byte)(in & 0xFF);
            buffer[2 * i + 1] = (byte)(in >> 8);
        }
        return buffer;
    }

    public String toString() {
        return "[Sample] samples: " + this.getSampleCount() + ", format: " + this.getFormat();
    }

    private static void checkFormat(AudioFormat af) {
        if (!af.matches(SC_AUDIO_FORMAT)) {
            throw new IllegalArgumentException("Unsupported audio format.\nReceived: " + af.toString() + "\nExpected: " + SC_AUDIO_FORMAT);
        }
    }
}

