/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.image.background;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import ml.miron.captcha.image.background.AbstractBackground;

public class GradiatedBackground
extends AbstractBackground {
    private final Color fromColor;
    private final Color toColor;

    public GradiatedBackground() {
        this(Color.DARK_GRAY, Color.WHITE);
    }

    public GradiatedBackground(Color from, Color to) {
        this.fromColor = from;
        this.toColor = to;
    }

    @Override
    public BufferedImage getBackground(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g = img.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHints(hints);
        GradientPaint ytow = new GradientPaint(0.0f, 0.0f, this.fromColor, width, height, this.toColor);
        g.setPaint(ytow);
        g.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return img;
    }
}

