/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.image.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import ml.miron.captcha.image.renderer.Renderer;

public class FishEyeRenderer
implements Renderer {
    private final Color hColor;
    private final Color vColor;

    public FishEyeRenderer() {
        this(Color.BLACK, Color.BLACK);
    }

    public FishEyeRenderer(Color hColor, Color vColor) {
        this.hColor = hColor;
        this.vColor = vColor;
    }

    @Override
    public void gimp(BufferedImage image) {
        int i;
        int height = image.getHeight();
        int width = image.getWidth();
        int hstripes = height / 7;
        int vstripes = width / 7;
        int hspace = height / (hstripes + 1);
        int vspace = width / (vstripes + 1);
        Graphics2D graph = (Graphics2D)image.getGraphics();
        for (i = hspace; i < height; i += hspace) {
            graph.setColor(this.hColor);
            graph.drawLine(0, i, width, i);
        }
        for (i = vspace; i < width; i += vspace) {
            graph.setColor(this.vColor);
            graph.drawLine(i, 0, i, height);
        }
        int[] pix = new int[height * width];
        int j = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < height; ++k1) {
                pix[j] = image.getRGB(j1, k1);
                ++j;
            }
        }
        double distance = this.ranInt(width / 4, width / 3);
        int wMid = image.getWidth() / 2;
        int hMid = image.getHeight() / 2;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int relX = x - wMid;
                int relY = y - hMid;
                double d1 = Math.sqrt(relX * relX + relY * relY);
                if (!(d1 < distance)) continue;
                int j2 = wMid + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(x - wMid));
                int k2 = hMid + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(y - hMid));
                image.setRGB(x, y, pix[j2 * height + k2]);
            }
        }
        graph.dispose();
    }

    private int ranInt(int i, int j) {
        double d = Math.random();
        return (int)((double)i + (double)(j - i + 1) * d);
    }

    private double fishEyeFormula(double s) {
        if (s < 0.0) {
            return 0.0;
        }
        if (s > 1.0) {
            return s;
        }
        return -0.75 * s * s * s + 1.5 * s * s + 0.25 * s;
    }
}

