/*
 * Decompiled with CFR 0.152.
 */
package ml.miron.captcha.servlet;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ml.miron.captcha.audio.AudioCaptcha;
import ml.miron.captcha.audio.producer.NumberVoiceProducer;
import ml.miron.captcha.audio.producer.VoiceProducer;
import ml.miron.captcha.image.producer.DefaultTextProducer;
import ml.miron.captcha.util.CaptchaServletUtil;

public class AudioCaptchaServlet
extends HttpServlet
implements SingleThreadModel {
    private VoiceProducer voiceProducer;

    public void init() throws ServletException {
        if (this.getInitParameter("audio-path") != null) {
            this.fillVoiceProducer(this.getInitParameter("audio-path"));
        } else {
            this.voiceProducer = new NumberVoiceProducer();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AudioCaptcha.Builder builder = new AudioCaptcha.Builder().addNoise().addVoice(this.voiceProducer);
        String answer = (String)req.getSession().getAttribute("CAPTCHA");
        if (answer != null) {
            builder.addAnswer(new DefaultTextProducer(answer));
        } else {
            builder.addAnswer();
        }
        AudioCaptcha captcha = builder.build();
        req.getSession().setAttribute("CAPTCHA", (Object)captcha.getAnswer());
        CaptchaServletUtil.writeAudio(resp, captcha.getChallenge());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void fillVoiceProducer(String audioDir) {
        HashMap<Integer, String[]> voiceMap = new HashMap<Integer, String[]>();
        for (int i = 0; i < 10; ++i) {
            String fileName = audioDir + "/" + i + ".wav";
            if (((Object)((Object)this)).getClass().getResource(fileName) == null) {
                throw new IllegalArgumentException("File with next name does not exists: " + fileName);
            }
            voiceMap.put(i, new String[]{fileName});
        }
        this.voiceProducer = new NumberVoiceProducer(voiceMap);
    }
}

