/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.teradata;

import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.teradata.TeradataConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.teradata.jdbc.TeraDriver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class TeradataClient
extends BaseJdbcClient {
    private static final Logger log = Logger.getLogger(TeradataClient.class);

    @Inject
    public TeradataClient(JdbcConnectorId connectorId, BaseJdbcConfig config, TeradataConfig teradataConfig) throws SQLException {
        super(connectorId, config, "", (Driver)new TeraDriver());
    }

    public Set<String> getSchemaNames() {
        Connection connection = null;
        try {
            connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
            ResultSet resultSet = connection.getMetaData().getSchemas();
            ImmutableSet.Builder schemaNames = ImmutableSet.builder();
            while (resultSet.next()) {
                String schemaName = resultSet.getString(1).toLowerCase();
                log.info((Object)("Schemas list: " + schemaName));
                schemaNames.add((Object)schemaName);
            }
            ImmutableSet immutableSet = schemaNames.build();
            return immutableSet;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Failed closing connection", (Throwable)e);
                }
            }
        }
    }

    protected ResultSet getTables(Connection connection, String schemaName, String tableName) throws SQLException {
        return connection.getMetaData().getTables(null, schemaName, tableName, new String[]{"VIEW", "TABLE", "SYNONYM"});
    }

    @Nullable
    public JdbcTableHandle getTableHandle(SchemaTableName schemaTableName) {
        Connection connection = null;
        try {
            connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
            DatabaseMetaData metadata = connection.getMetaData();
            String jdbcSchemaName = schemaTableName.getSchemaName();
            String jdbcTableName = schemaTableName.getTableName();
            if (metadata.storesUpperCaseIdentifiers()) {
                jdbcSchemaName = jdbcSchemaName.toUpperCase();
                jdbcTableName = jdbcTableName.toUpperCase();
            }
            ResultSet resultSet = this.getTables(connection, jdbcSchemaName, jdbcTableName);
            ArrayList<JdbcTableHandle> tableHandles = new ArrayList<JdbcTableHandle>();
            while (resultSet.next()) {
                log.info((Object)String.format("[%s]Schema names: - START", this.connectorId));
                int columns = resultSet.getMetaData().getColumnCount();
                for (int j = 1; j <= columns; ++j) {
                    log.info((Object)String.format("[%s]: %s", resultSet.getMetaData().getColumnName(j), resultSet.getObject(j)));
                }
                log.info((Object)String.format("[%s]Schema names: - END", this.connectorId));
                tableHandles.add(new JdbcTableHandle(this.connectorId, schemaTableName, resultSet.getString("TABLE_CAT"), resultSet.getString("TABLE_SCHEM"), resultSet.getString("TABLE_NAME")));
            }
            if (tableHandles.isEmpty()) {
                JdbcTableHandle jdbcTableHandle = null;
                return jdbcTableHandle;
            }
            if (tableHandles.size() > 1) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Multiple tables matched: " + schemaTableName);
            }
            JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)Iterables.getOnlyElement(tableHandles);
            return jdbcTableHandle;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Failed closing connection", (Throwable)e);
                }
            }
        }
    }

    public List<JdbcColumnHandle> getColumns(JdbcTableHandle tableHandle) {
        Connection connection = null;
        ArrayList<JdbcColumnHandle> columns = new ArrayList<JdbcColumnHandle>();
        try {
            log.info((Object)"Listing connection properties - START");
            for (String string : this.connectionProperties.stringPropertyNames()) {
                log.info((Object)String.format("[%s] %s", string, this.connectionProperties.getProperty(string)));
            }
            log.info((Object)"Listing connection properties - END");
            connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
            DatabaseMetaData metadata = connection.getMetaData();
            if (tableHandle != null) {
                if (tableHandle.getSchemaName() == null) {
                    throw new SchemaNotFoundException("No schema name!");
                }
                String schemaName = tableHandle.getSchemaName().toUpperCase();
                String tableName = tableHandle.getTableName().toUpperCase();
                ResultSet resultSet = metadata.getColumns(null, schemaName, tableName, null);
                boolean found = false;
                while (resultSet.next()) {
                    found = true;
                    Type columnType = this.toPrestoType(resultSet.getInt("DATA_TYPE"));
                    if (columnType == null) continue;
                    String columnName = resultSet.getString("COLUMN_NAME");
                    columns.add(new JdbcColumnHandle(this.connectorId, columnName, columnType));
                }
                if (!found) {
                    throw new TableNotFoundException(tableHandle.getSchemaTableName());
                }
                if (columns.isEmpty()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table has no supported column types: %s", tableHandle.getSchemaTableName()));
                }
            }
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Failed closing connection", (Throwable)e);
                }
            }
        }
        return ImmutableList.copyOf(columns);
    }

    public List<SchemaTableName> getTableNames(@Nullable String schema) {
        Connection connection = null;
        try {
            connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers() && schema != null) {
                schema = schema.toUpperCase();
            }
            ResultSet resultSet = this.getTables(connection, schema, null);
            ImmutableList.Builder list = ImmutableList.builder();
            while (resultSet.next()) {
                list.add((Object)this.getSchemaTableName(resultSet));
            }
            ImmutableList immutableList = list.build();
            return immutableList;
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"Failed closing connection", (Throwable)e);
                }
            }
        }
    }

    protected SchemaTableName getSchemaTableName(ResultSet resultSet) throws SQLException {
        String tableSchema = resultSet.getString("TABLE_SCHEM");
        String tableName = resultSet.getString("TABLE_NAME");
        if (tableSchema != null) {
            tableSchema = tableSchema.toLowerCase();
        }
        if (tableName != null) {
            tableName = tableName.toLowerCase();
        }
        return new SchemaTableName(tableSchema, tableName);
    }

    public String buildSql(JdbcSplit split, List<JdbcColumnHandle> columnHandles) {
        log.info((Object)"We are debugging how sql is built!");
        log.info((Object)String.format("[split]: %s", split));
        return super.buildSql(split, columnHandles);
    }

    protected void execute(Connection connection, String query) throws SQLException {
        log.info((Object)String.format("We just received the following query for execution: %s", query));
        super.execute(connection, this.rewriteQuery(query));
    }

    @VisibleForTesting
    protected String rewriteQuery(String query) {
        return query;
    }
}

