/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.GuaguaService;
import ml.shifu.guagua.MemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.master.GuaguaMasterService;
import ml.shifu.guagua.master.InternalMasterCoordinator;
import ml.shifu.guagua.worker.GuaguaWorkerService;
import ml.shifu.guagua.worker.InternalWorkerCoordinator;

public abstract class GuaguaUnitDriver<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable> {
    private static final String GUAGUA_UNIT_TEST = "Guagua Unit Test";
    private Properties props;
    private GuaguaService masterService;
    private List<GuaguaService> workerServices;
    private ExecutorService executor;
    private int iteration;
    private List<GuaguaFileSplit[]> fileSplits;

    public GuaguaUnitDriver(Properties props) {
        this.props = props;
    }

    public abstract List<GuaguaFileSplit[]> generateWorkerSplits(String var1) throws IOException;

    protected void setUp() {
        try {
            this.fileSplits = this.generateWorkerSplits(this.props.getProperty("guagua.input.dir"));
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        this.executor = Executors.newFixedThreadPool(this.fileSplits.size() + 1);
        this.props.setProperty("guagua.master.system.intercepters", InternalMasterCoordinator.class.getName());
        this.props.setProperty("guagua.worker.system.intercepters", InternalWorkerCoordinator.class.getName());
        this.props.setProperty("guagua.worker.number", this.fileSplits.size() + "");
        this.iteration = Integer.parseInt(this.props.getProperty("guagua.iteration.count"));
        this.workerServices = new ArrayList<GuaguaService>();
        this.masterService = new GuaguaMasterService();
        MemoryCoordinator coordinator = new MemoryCoordinator(this.fileSplits.size(), this.iteration);
        this.masterService.setAppId(GUAGUA_UNIT_TEST);
        this.masterService.setContainerId("0");
        ((GuaguaMasterService)this.masterService).setCoordinator(coordinator);
        this.masterService.init(this.props);
        for (int i = 0; i < this.fileSplits.size(); ++i) {
            GuaguaWorkerService workerService = new GuaguaWorkerService();
            workerService.setAppId(GUAGUA_UNIT_TEST);
            workerService.setContainerId(i + 1 + "");
            workerService.setSplits(Arrays.asList((Object[])this.fileSplits.get(i)));
            workerService.setCoordinator(coordinator);
            workerService.init(this.props);
            this.workerServices.add(workerService);
        }
    }

    public void run() {
        this.setUp();
        this.doRun();
        this.tearDown();
    }

    protected void doRun() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                GuaguaUnitDriver.this.masterService.start();
                GuaguaUnitDriver.this.masterService.run(null);
                GuaguaUnitDriver.this.masterService.stop();
            }
        });
        for (final GuaguaService workerService : this.workerServices) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    workerService.start();
                    workerService.run(null);
                    workerService.stop();
                }
            });
        }
    }

    protected void tearDown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

