/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMap {
    private static final Logger LOG = LoggerFactory.getLogger(JMap.class);
    public static final String CMD = "jmap ";
    public static final String ARGS = " -histo ";

    protected JMap() {
    }

    public static int getProcessId() {
        String processId = ManagementFactory.getRuntimeMXBean().getName();
        if (processId.contains("@")) {
            processId = processId.substring(0, processId.indexOf("@"));
        }
        return Integer.parseInt(processId);
    }

    public static void heapHistogramDump(int numLines) {
        JMap.heapHistogramDump(numLines, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void heapHistogramDump(int numLines, PrintStream printStream) {
        BufferedReader in = null;
        try {
            Process p = Runtime.getRuntime().exec("jmap  -histo " + JMap.getProcessId());
            in = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));
            printStream.println("JMap histo dump at " + new Date());
            String line = in.readLine();
            for (int i = 0; i < numLines && line != null; ++i) {
                printStream.println("--\t" + line);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            LOG.error("IOException in dump heap", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error("Error in closing input stream", (Throwable)e);
                }
            }
        }
    }
}

