/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.basic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.csv.basic.BaseCachedColumn;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.FileData;
import org.encog.app.quant.QuantError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.logging.EncogLogging;

public class BasicCachedFile
extends BasicFile {
    private final Map<String, BaseCachedColumn> columnMapping = new HashMap<String, BaseCachedColumn>();
    private final List<BaseCachedColumn> columns = new ArrayList<BaseCachedColumn>();

    public final void addColumn(BaseCachedColumn column) {
        this.columns.add(column);
        this.columnMapping.put(column.getName(), column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void analyze(File input, boolean headers, CSVFormat format) {
        this.resetStatus();
        this.setInputFilename(input);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.columnMapping.clear();
        this.columns.clear();
        BufferedReader reader = null;
        try {
            int recordCount = 0;
            reader = new BufferedReader(new FileReader(this.getInputFilename()));
            while (reader.readLine() != null) {
                this.updateStatus(true);
                ++recordCount;
            }
            if (headers) {
                --recordCount;
            }
            this.setRecordCount(recordCount);
        }
        catch (IOException ex) {
            throw new QuantError(ex);
        }
        finally {
            this.reportDone(true);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new QuantError(e);
                }
            }
            this.setInputFilename(input);
            this.setExpectInputHeaders(headers);
            this.setInputFormat(format);
        }
        ReadCSV csv = null;
        try {
            csv = new ReadCSV(input.toString(), headers, format);
            if (!csv.next()) {
                throw new QuantError("File is empty");
            }
            for (int i = 0; i < csv.getColumnCount(); ++i) {
                String name = headers ? this.attemptResolveName(csv.getColumnNames().get(i)) : "Column-" + (i + 1);
                String str = csv.get(i);
                boolean io = false;
                try {
                    Double.parseDouble(str);
                    io = true;
                }
                catch (NumberFormatException ex) {
                    EncogLogging.log(ex);
                }
                this.addColumn(new FileData(name, i, io, io));
            }
        }
        finally {
            csv.close();
            this.setAnalyzed(true);
        }
    }

    private String attemptResolveName(String name) {
        String name2 = name.toLowerCase();
        if (name2.indexOf("open") != -1) {
            return "open";
        }
        if (name2.indexOf("close") != -1) {
            return "close";
        }
        if (name2.indexOf("low") != -1) {
            return "low";
        }
        if (name2.indexOf("hi") != -1) {
            return "high";
        }
        if (name2.indexOf("vol") != -1) {
            return "volume";
        }
        if (name2.indexOf("date") != -1 || name.indexOf("yyyy") != -1) {
            return "date";
        }
        if (name2.indexOf("time") != -1) {
            return "time";
        }
        return name;
    }

    public final String getColumnData(String name, ReadCSV csv) {
        if (!this.columnMapping.containsKey(name)) {
            return null;
        }
        BaseCachedColumn column = this.columnMapping.get(name);
        if (!(column instanceof FileData)) {
            return null;
        }
        FileData fd = (FileData)column;
        return csv.get(fd.getIndex());
    }

    public final Map<String, BaseCachedColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public final List<BaseCachedColumn> getColumns() {
        return this.columns;
    }
}

