/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.shuffle;

import java.io.File;
import java.io.PrintWriter;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class ShuffleCSV
extends BasicFile {
    public static final int DEFAULT_BUFFER_SIZE = 5000;
    private int bufferSize;
    private LoadedRow[] buffer;
    private int remaining;

    public ShuffleCSV() {
        this.setBufferSize(5000);
    }

    public final void analyze(File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.performBasicCounts();
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    private LoadedRow getNextRow(ReadCSV csv) {
        if (this.remaining == 0) {
            this.loadBuffer(csv);
        }
        while (this.remaining > 0) {
            int index = RangeRandomizer.randomInt(0, this.bufferSize - 1);
            if (this.buffer[index] == null) continue;
            LoadedRow result = this.buffer[index];
            this.buffer[index] = null;
            --this.remaining;
            return result;
        }
        return null;
    }

    private void loadBuffer(ReadCSV csv) {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        int index = 0;
        while (csv.next() && index < this.bufferSize && !this.shouldStop()) {
            LoadedRow row = new LoadedRow(csv);
            this.buffer[index++] = row;
        }
        this.remaining = index;
    }

    public final void process(File outputFile) {
        LoadedRow row;
        this.validateAnalyzed();
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getInputFormat());
        PrintWriter tw = this.prepareOutputFile(outputFile);
        this.resetStatus();
        while ((row = this.getNextRow(csv)) != null) {
            this.writeRow(tw, row);
            this.updateStatus(false);
        }
        this.reportDone(false);
        tw.close();
        csv.close();
    }

    public final void setBufferSize(int s) {
        this.bufferSize = s;
        this.buffer = new LoadedRow[this.bufferSize];
    }
}

