/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.neural.thermal.HopfieldNetwork;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class PersistHopfield
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return HopfieldNetwork.class.getSimpleName();
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        HopfieldNetwork result = new HopfieldNetwork();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("HOPFIELD") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (!section.getSectionName().equals("HOPFIELD") || !section.getSubSectionName().equals("NETWORK")) continue;
            params = section.parseParams();
            result.setWeights(NumberList.fromList(CSVFormat.EG_FORMAT, params.get("weights")));
            result.setCurrentState(NumberList.fromList(CSVFormat.EG_FORMAT, params.get("output")));
            result.setNeuronCount(EncogFileSection.parseInt(params, "neurons"));
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        HopfieldNetwork hopfield = (HopfieldNetwork)obj;
        out.addSection("HOPFIELD");
        out.addSubSection("PARAMS");
        out.addProperties(hopfield.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("weights", hopfield.getWeights());
        out.writeProperty("output", hopfield.getCurrentState().getData());
        out.writeProperty("neurons", hopfield.getNeuronCount());
        out.flush();
    }
}

