/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.mapreduce.GuaguaInputSplit;
import ml.shifu.guagua.mapreduce.GuaguaMRRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaInputFormat
extends TextInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaInputFormat.class);
    private static Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            long cmp = o1.length - o2.length;
            return cmp == 0L ? 0 : (cmp < 0L ? -1 : 1);
        }
    };

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List<InputSplit> newSplits = null;
        boolean combinable = job.getConfiguration().getBoolean("guagua.split.combinable", false);
        if (combinable) {
            long blockSize = FileSystem.get((Configuration)job.getConfiguration()).getDefaultBlockSize();
            long combineSize = job.getConfiguration().getLong("guagua.split.maxCombinedSplitSize", blockSize);
            if (combineSize == 0L) {
                combineSize = blockSize;
            }
            job.getConfiguration().setLong("mapred.min.split.size", 1L);
            job.getConfiguration().setLong("mapred.max.split.size", combineSize);
            List splits = super.getSplits(job);
            LOG.debug("combine size:{}, splits:{}", (Object)combineSize, (Object)splits);
            newSplits = this.getFinalCombineGuaguaSplits(splits, combineSize);
        } else {
            newSplits = this.getGuaguaSplits(job);
        }
        int masters = job.getConfiguration().getInt("guagua.master.number", 1);
        for (int i = 0; i < masters; ++i) {
            newSplits.add(new GuaguaInputSplit(true, (FileSplit)null));
        }
        int mapperSize = newSplits.size();
        LOG.info("Input size including master: {}", (Object)mapperSize);
        LOG.debug("input splits: {}", newSplits);
        job.getConfiguration().set("guagua.worker.number", mapperSize - masters + "");
        return newSplits;
    }

    protected List<InputSplit> getFinalCombineGuaguaSplits(List<InputSplit> newSplits, long combineSize) throws IOException {
        List<List<InputSplit>> combinePigSplits;
        try {
            combinePigSplits = GuaguaInputFormat.getCombineGuaguaSplits(newSplits, combineSize);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GuaguaRuntimeException((Throwable)e);
        }
        newSplits = new ArrayList<InputSplit>();
        for (List<InputSplit> inputSplits : combinePigSplits) {
            FileSplit[] fss = new FileSplit[inputSplits.size()];
            for (int i = 0; i < inputSplits.size(); ++i) {
                fss[i] = (FileSplit)inputSplits.get(i);
            }
            newSplits.add(new GuaguaInputSplit(false, fss));
        }
        return newSplits;
    }

    protected List<InputSplit> getGuaguaSplits(JobContext job) throws IOException {
        long minSize = Math.max(this.getFormatMinSplitSize(), GuaguaInputFormat.getMinSplitSize((JobContext)job));
        long maxSize = GuaguaInputFormat.getMaxSplitSize((JobContext)job);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        List files = this.listStatus(job);
        for (FileStatus file : files) {
            Path path = file.getPath();
            if (this.isPigOrHadoopMetaFile(path)) continue;
            FileSystem fs = path.getFileSystem(job.getConfiguration());
            long length = file.getLen();
            BlockLocation[] blkLocations = fs.getFileBlockLocations(file, 0L, length);
            if (length != 0L && this.isSplitable(job, path)) {
                long blockSize = file.getBlockSize();
                long splitSize = this.computeSplitSize(blockSize, minSize, maxSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    int blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add(new GuaguaInputSplit(false, new FileSplit(path, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts())));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add(new GuaguaInputSplit(false, new FileSplit(path, length - bytesRemaining, bytesRemaining, blkLocations[blkLocations.length - 1].getHosts())));
                continue;
            }
            if (length != 0L) {
                splits.add(new GuaguaInputSplit(false, new FileSplit(path, 0L, length, blkLocations[0].getHosts())));
                continue;
            }
            splits.add(new GuaguaInputSplit(false, new FileSplit(path, 0L, length, new String[0])));
        }
        job.getConfiguration().setLong("mapreduce.input.num.files", (long)files.size());
        LOG.debug("Total # of splits: {}", (Object)splits.size());
        return splits;
    }

    public static List<List<InputSplit>> getCombineGuaguaSplits(List<InputSplit> oneInputSplits, long maxCombinedSplitSize) throws IOException, InterruptedException {
        ArrayList<InputSplit> combinedSplits;
        ArrayList<Node> nodes = new ArrayList<Node>();
        HashMap<Object, Node> nodeMap = new HashMap<Object, Node>();
        ArrayList<List<InputSplit>> result = new ArrayList<List<InputSplit>>();
        ArrayList<Long> resultLengths = new ArrayList<Long>();
        long comparableSplitId = 0L;
        int size = 0;
        int nSplits = oneInputSplits.size();
        InputSplit lastSplit = null;
        int emptyCnt = 0;
        for (InputSplit split : oneInputSplits) {
            if (split.getLength() == 0L) {
                ++emptyCnt;
                continue;
            }
            if (split.getLength() >= maxCombinedSplitSize) {
                ++comparableSplitId;
                ArrayList<InputSplit> combinedSplits2 = new ArrayList<InputSplit>();
                combinedSplits2.add(split);
                result.add(combinedSplits2);
                resultLengths.add(split.getLength());
                continue;
            }
            ComparableSplit csplit = new ComparableSplit(split, comparableSplitId++);
            Object[] locations = split.getLocations();
            Arrays.sort(locations);
            HashSet<Object> locationSeen = new HashSet<Object>();
            for (Object location : locations) {
                if (locationSeen.contains(location)) continue;
                Node node = (Node)nodeMap.get(location);
                if (node == null) {
                    node = new Node();
                    nodes.add(node);
                    nodeMap.put(location, node);
                }
                node.add(csplit);
                csplit.add(node);
                locationSeen.add(location);
            }
            lastSplit = split;
            ++size;
        }
        if (nSplits > 0 && emptyCnt == nSplits) {
            combinedSplits = new ArrayList<InputSplit>();
            combinedSplits.add(oneInputSplits.get(0));
            result.add(combinedSplits);
        } else if (size == 1) {
            combinedSplits = new ArrayList();
            combinedSplits.add(lastSplit);
            result.add(combinedSplits);
        } else if (size > 1) {
            Collections.sort(nodes, nodeComparator);
            DummySplit dummy = new DummySplit();
            ComparableSplit dummyComparableSplit = new ComparableSplit(dummy, -1L);
            block2: for (Node node : nodes) {
                node.sort();
                long totalSize = 0L;
                ArrayList<ComparableSplit> splits = node.getSplits();
                ArrayList<InputSplit> combinedSplits3 = new ArrayList<InputSplit>();
                ArrayList<ComparableSplit> combinedComparableSplits = new ArrayList<ComparableSplit>();
                while (!splits.isEmpty()) {
                    combinedSplits3.add(splits.get(0).getSplit());
                    combinedComparableSplits.add(splits.get(0));
                    int startIdx = 1;
                    int lenSplits = splits.size();
                    long spaceLeft = maxCombinedSplitSize - (totalSize += splits.get(0).getSplit().getLength());
                    dummy.setLength(spaceLeft);
                    int idx = Collections.binarySearch(node.getSplits().subList(startIdx, lenSplits), dummyComparableSplit);
                    idx = -idx - 1 + startIdx;
                    while (idx < lenSplits) {
                        long thisLen = splits.get(idx).getSplit().getLength();
                        combinedSplits3.add(splits.get(idx).getSplit());
                        combinedComparableSplits.add(splits.get(idx));
                        totalSize += thisLen;
                        if ((spaceLeft -= thisLen) <= 0L || (startIdx = idx + 1) >= lenSplits) break;
                        dummy.setLength(spaceLeft);
                        idx = Collections.binarySearch(node.getSplits().subList(startIdx, lenSplits), dummyComparableSplit);
                        idx = -idx - 1 + startIdx;
                    }
                    if (totalSize > maxCombinedSplitSize / 2L) {
                        result.add(combinedSplits3);
                        resultLengths.add(totalSize);
                        GuaguaInputFormat.removeSplits(combinedComparableSplits);
                        totalSize = 0L;
                        combinedSplits3 = new ArrayList();
                        combinedComparableSplits.clear();
                        splits = node.getSplits();
                        continue;
                    }
                    if (combinedSplits3.size() != lenSplits) {
                        throw new AssertionError((Object)"Combined split logic error!");
                    }
                    continue block2;
                }
            }
            ArrayList<ComparableSplit> leftoverSplits = new ArrayList<ComparableSplit>();
            HashSet<InputSplit> seen = new HashSet<InputSplit>();
            for (Node node : nodes) {
                for (ComparableSplit split : node.getSplits()) {
                    if (seen.contains(split.getSplit())) continue;
                    seen.add(split.getSplit());
                    leftoverSplits.add(split);
                }
            }
            if (!leftoverSplits.isEmpty()) {
                long totalSize = 0L;
                ArrayList<InputSplit> combinedSplits4 = new ArrayList<InputSplit>();
                ArrayList<ComparableSplit> combinedComparableSplits = new ArrayList<ComparableSplit>();
                int splitLen = leftoverSplits.size();
                for (int i = 0; i < splitLen; ++i) {
                    ComparableSplit split = (ComparableSplit)leftoverSplits.get(i);
                    long thisLen = split.getSplit().getLength();
                    if (totalSize + thisLen >= maxCombinedSplitSize) {
                        GuaguaInputFormat.removeSplits(combinedComparableSplits);
                        result.add(combinedSplits4);
                        resultLengths.add(totalSize);
                        combinedSplits4 = new ArrayList();
                        combinedComparableSplits.clear();
                        totalSize = 0L;
                    }
                    combinedSplits4.add(split.getSplit());
                    combinedComparableSplits.add(split);
                    totalSize += split.getSplit().getLength();
                    if (i != splitLen - 1) continue;
                    for (int j = 0; j < result.size(); ++j) {
                        if ((Long)resultLengths.get(j) + totalSize > maxCombinedSplitSize) continue;
                        List isList = (List)result.get(j);
                        for (InputSplit csplit : combinedSplits4) {
                            isList.add(csplit);
                        }
                        GuaguaInputFormat.removeSplits(combinedComparableSplits);
                        combinedSplits4.clear();
                        break;
                    }
                    if (combinedSplits4.isEmpty()) continue;
                    GuaguaInputFormat.removeSplits(combinedComparableSplits);
                    result.add(combinedSplits4);
                }
            }
        }
        LOG.info("Total input paths (combined) to process : {}", (Object)result.size());
        return result;
    }

    private static void removeSplits(List<ComparableSplit> splits) {
        for (ComparableSplit split : splits) {
            split.removeFromNodes();
        }
    }

    protected boolean isPigOrHadoopMetaFile(Path path) {
        return path.toString().indexOf("_SUCCESS") >= 0 || path.toString().indexOf("pig_header") >= 0 || path.toString().indexOf("pig_schema") >= 0;
    }

    protected boolean isSplitable(JobContext context, Path file) {
        if (file.getName().endsWith("bz2")) {
            return true;
        }
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return codec == null;
    }

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new GuaguaMRRecordReader(context.getConfiguration().getInt("guagua.iteration.count", -1));
    }

    private static class Node {
        private long length = 0L;
        private ArrayList<ComparableSplit> splits = new ArrayList();
        private boolean sorted = false;

        Node() throws IOException, InterruptedException {
        }

        void add(ComparableSplit split) throws IOException, InterruptedException {
            this.splits.add(split);
            ++this.length;
        }

        void remove(ComparableSplit split) {
            int index;
            if (!this.sorted) {
                this.sort();
            }
            if ((index = Collections.binarySearch(this.splits, split)) >= 0) {
                this.splits.remove(index);
                --this.length;
            }
        }

        void sort() {
            if (!this.sorted) {
                Collections.sort(this.splits);
                this.sorted = true;
            }
        }

        ArrayList<ComparableSplit> getSplits() {
            return this.splits;
        }

        public long getLength() {
            return this.length;
        }
    }

    private static class DummySplit
    extends InputSplit {
        private long length;

        private DummySplit() {
        }

        public String[] getLocations() {
            return null;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }
    }

    private static final class ComparableSplit
    implements Comparable<ComparableSplit> {
        private InputSplit rawInputSplit;
        private HashSet<Node> nodes;
        private long id;

        ComparableSplit(InputSplit split, long id) {
            this.rawInputSplit = split;
            this.nodes = new HashSet();
            this.id = id;
        }

        void add(Node node) {
            this.nodes.add(node);
        }

        void removeFromNodes() {
            for (Node node : this.nodes) {
                node.remove(this);
            }
        }

        public InputSplit getSplit() {
            return this.rawInputSplit;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ComparableSplit)) {
                return false;
            }
            return this.compareTo((ComparableSplit)other) == 0;
        }

        public int hashCode() {
            return 41;
        }

        @Override
        public int compareTo(ComparableSplit other) {
            try {
                long cmp = this.rawInputSplit.getLength() - other.rawInputSplit.getLength();
                return cmp == 0L ? (this.id == other.id ? 0 : (this.id < other.id ? -1 : 1)) : (cmp < 0L ? 1 : -1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

