/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.GuaguaService;
import ml.shifu.guagua.InMemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.io.Serializer;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.Progressable;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.util.StringUtils;
import ml.shifu.guagua.worker.LocalWorkerCoordinator;
import ml.shifu.guagua.worker.WorkerComputable;
import ml.shifu.guagua.worker.WorkerContext;
import ml.shifu.guagua.worker.WorkerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaWorkerService<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements GuaguaService {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaWorkerService.class);
    private Properties props;
    private WorkerComputable<MASTER_RESULT, WORKER_RESULT> workerComputable;
    private int totalIteration;
    private List<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> workerInterceptors;
    private List<GuaguaFileSplit> splits;
    private String appId;
    private String containerId;
    private String masterResultClassName;
    private String workerResultClassName;
    private WorkerContext<MASTER_RESULT, WORKER_RESULT> context;
    private InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator;
    private int overThresholdCount = 0;
    private static final int COUNT_THRESHOLD = 3;

    @Override
    public void start() {
        WorkerContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        context.setCurrentIteration(0);
        for (WorkerInterceptor<MASTER_RESULT, WORKER_RESULT> workerIntercepter : this.getWorkerInterceptors()) {
            workerIntercepter.preApplication(context);
        }
    }

    @Override
    public void stop() {
        WorkerContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        context.setCurrentIteration(context.getCurrentIteration() + 1);
        int interceptersSize = this.getWorkerInterceptors().size();
        Throwable exception = null;
        for (int i = 0; i < interceptersSize; ++i) {
            try {
                this.getWorkerInterceptors().get(interceptersSize - 1 - i).postApplication(context);
                continue;
            }
            catch (Throwable e) {
                LOG.error("Error in worker intercepters cleaning.", e);
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw new GuaguaRuntimeException(exception);
        }
    }

    @Override
    public void run(Progressable progress) {
        int initialIteration;
        WorkerContext<MASTER_RESULT, WORKER_RESULT> context = this.buildContext();
        for (int i = initialIteration = context.getCurrentIteration(); i < this.getTotalIteration(); ++i) {
            int iteration = i + 1;
            context.setCurrentIteration(iteration);
            this.iterate(context, initialIteration + 1, progress);
            MASTER_RESULT masterResult = context.getLastMasterResult();
            if (masterResult instanceof HaltBytable && ((HaltBytable)masterResult).isHalt()) break;
        }
    }

    protected WORKER_RESULT iterate(WorkerContext<MASTER_RESULT, WORKER_RESULT> context, int initialIteration, Progressable progress) {
        WORKER_RESULT workerResult;
        int iteration = context.getCurrentIteration();
        String status = "Start worker iteration ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        for (WorkerInterceptor<MASTER_RESULT, WORKER_RESULT> workerIntercepter : this.getWorkerInterceptors()) {
            workerIntercepter.preIteration(context);
        }
        status = "Start worker computing ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
        }
        long start = System.nanoTime();
        boolean isKill = false;
        try {
            workerResult = this.workerComputable.compute(context);
            context.setWorkerResult(workerResult);
            long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long threashold = NumberFormatUtils.getLong(context.getProps().getProperty("guagua.computation.time.threshold"), 60000L);
            if (time >= threashold && iteration > initialIteration) {
                ++this.overThresholdCount;
                if (this.overThresholdCount >= 3) {
                    this.overThresholdCount = 0;
                    LOG.warn("Computation time is too long:{}, kill itself to make fail-over work. ", (Object)time);
                    isKill = true;
                }
            }
            status = "Complete worker computing ( %s/%s ), progress %s%%";
            if (progress != null) {
                progress.progress(iteration - 1, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), (iteration - 1) * 100 / this.getTotalIteration()), false, false);
            }
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException("Error in worker computation", e);
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException("Error in worker computation", e);
        }
        int interceptersSize = this.getWorkerInterceptors().size();
        for (int i = 0; i < interceptersSize; ++i) {
            this.getWorkerInterceptors().get(interceptersSize - 1 - i).postIteration(context);
        }
        status = "Complete worker iteration ( %s/%s ), progress %s%%";
        if (progress != null) {
            progress.progress(iteration, this.getTotalIteration(), String.format(status, iteration, this.getTotalIteration(), iteration * 100 / this.getTotalIteration()), true, isKill);
        }
        return workerResult;
    }

    private WorkerContext<MASTER_RESULT, WORKER_RESULT> buildContext() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        this.context = new WorkerContext(this.getTotalIteration(), this.getAppId(), this.getProps(), this.getContainerId(), this.getSplits(), this.getMasterResultClassName(), this.getWorkerResultClassName());
        return this.getContext();
    }

    @Override
    public void init(Properties props) {
        this.setProps(props);
        this.checkAndSetWorkerIntercepters(props);
        this.setWorkerComputable(this.newWorkerComputable());
        this.setTotalIteration(Integer.valueOf(this.getProps().getProperty("guagua.iteration.count", "2147483647")));
        this.setMasterResultClassName(this.getProps().getProperty("guagua.master.result.class"));
        this.setWorkerResultClassName(this.getProps().getProperty("guagua.worker.result.class"));
    }

    private void checkAndSetWorkerIntercepters(Properties props) {
        String workerInterceptersStr;
        ArrayList<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> workerIntercepters = new ArrayList<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>>();
        String systemWorkerInterceptersStr = StringUtils.get(props.getProperty("guagua.worker.system.intercepters"), "ml.shifu.guagua.worker.WorkerTimer,ml.shifu.guagua.worker.MemoryStatsWorkerInterceptor,ml.shifu.guagua.worker.SyncWorkerCoordinator");
        if (systemWorkerInterceptersStr != null && systemWorkerInterceptersStr.length() != 0) {
            Object[] intercepters = systemWorkerInterceptersStr.split(",");
            if (LOG.isInfoEnabled()) {
                LOG.info("System worker intercepters: {}.", (Object)Arrays.toString(intercepters));
            }
            for (Object intercepter : intercepters) {
                WorkerInterceptor instance = (WorkerInterceptor)ReflectionUtils.newInstance(((String)intercepter).trim());
                if (instance instanceof BasicCoordinator) {
                    String serialierClassName = StringUtils.get(props.getProperty("guagua.master.io.serializer"), "ml.shifu.guagua.io.BytableSerializer");
                    Serializer masterSerializer = (Serializer)ReflectionUtils.newInstance(serialierClassName);
                    ((BasicCoordinator)((Object)instance)).setMasterSerializer(masterSerializer);
                    serialierClassName = StringUtils.get(props.getProperty("guagua.worker.io.serializer"), "ml.shifu.guagua.io.BytableSerializer");
                    Serializer workerSerializer = (Serializer)ReflectionUtils.newInstance(serialierClassName);
                    ((BasicCoordinator)((Object)instance)).setWorkerSerializer(workerSerializer);
                } else if (instance instanceof LocalWorkerCoordinator) {
                    ((LocalWorkerCoordinator)instance).setCoordinator(this.getCoordinator());
                }
                workerIntercepters.add(instance);
            }
        }
        if ((workerInterceptersStr = props.getProperty("guagua.worker.intercepters")) != null && workerInterceptersStr.length() != 0) {
            Object[] intercepters = workerInterceptersStr.split(",");
            if (LOG.isInfoEnabled()) {
                LOG.info("Customized worker intercepters: {}.", (Object)Arrays.toString(intercepters));
            }
            for (Object intercepter : intercepters) {
                WorkerInterceptor instance = (WorkerInterceptor)ReflectionUtils.newInstance(((String)intercepter).trim());
                workerIntercepters.add(instance);
            }
        }
        this.setWorkerInterceptors(workerIntercepters);
    }

    private WorkerComputable<MASTER_RESULT, WORKER_RESULT> newWorkerComputable() {
        WorkerComputable workerComputable;
        try {
            workerComputable = (WorkerComputable)ReflectionUtils.newInstance(Class.forName(this.getProps().get("guagua.worker.computable.class").toString()));
        }
        catch (ClassNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
        return workerComputable;
    }

    private WorkerContext<MASTER_RESULT, WORKER_RESULT> getContext() {
        return this.context;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public List<GuaguaFileSplit> getSplits() {
        return this.splits;
    }

    @Override
    public void setSplits(List<GuaguaFileSplit> splits) {
        this.splits = splits;
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public WorkerComputable<MASTER_RESULT, WORKER_RESULT> getWorkerComputable() {
        return this.workerComputable;
    }

    public void setWorkerComputable(WorkerComputable<MASTER_RESULT, WORKER_RESULT> workerComputable) {
        this.workerComputable = workerComputable;
    }

    public int getTotalIteration() {
        return this.totalIteration;
    }

    public void setTotalIteration(int totalIteration) {
        this.totalIteration = totalIteration;
    }

    public List<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> getWorkerInterceptors() {
        return this.workerInterceptors;
    }

    public void setWorkerInterceptors(List<WorkerInterceptor<MASTER_RESULT, WORKER_RESULT>> workerInterceptors) {
        this.workerInterceptors = workerInterceptors;
    }

    public String getMasterResultClassName() {
        return this.masterResultClassName;
    }

    public void setMasterResultClassName(String masterResultClassName) {
        this.masterResultClassName = masterResultClassName;
    }

    public String getWorkerResultClassName() {
        return this.workerResultClassName;
    }

    public void setWorkerResultClassName(String workerResultClassName) {
        this.workerResultClassName = workerResultClassName;
    }

    public InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator) {
        this.coordinator = coordinator;
    }
}

