/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.basic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.NullStatusReportable;
import org.encog.StatusReportable;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.quant.QuantError;
import org.encog.app.quant.QuantTask;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class BasicFile
implements QuantTask {
    public static final int REPORT_INTERVAL = 10000;
    private String[] inputHeadings;
    private int precision = 10;
    private boolean analyzed;
    private File inputFilename;
    private boolean expectInputHeaders;
    private CSVFormat inputFormat;
    private int columnCount;
    private StatusReportable report = new NullStatusReportable();
    private int reportInterval = 10000;
    private int recordCount;
    private int lastUpdate;
    private int currentRecord;
    private boolean produceOutputHeaders = true;
    private boolean cancel;
    private CSVFormat outputFormat;
    private AnalystScript script;

    public static void appendSeparator(StringBuilder line, CSVFormat format) {
        if (line.length() > 0 && !line.toString().endsWith(format.getSeparator() + "")) {
            line.append(format.getSeparator());
        }
    }

    public BasicFile() {
        this.resetStatus();
    }

    public final int getColumnCount() {
        return this.columnCount;
    }

    public final File getInputFilename() {
        return this.inputFilename;
    }

    public final CSVFormat getInputFormat() {
        return this.inputFormat;
    }

    public final String[] getInputHeadings() {
        return this.inputHeadings;
    }

    public final CSVFormat getOutputFormat() {
        return this.outputFormat;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getRecordCount() {
        if (!this.analyzed) {
            throw new QuantError("Must analyze file first.");
        }
        return this.recordCount;
    }

    public final StatusReportable getReport() {
        return this.report;
    }

    public final int getReportInterval() {
        return this.reportInterval;
    }

    public final boolean isAnalyzed() {
        return this.analyzed;
    }

    public final boolean isExpectInputHeaders() {
        return this.expectInputHeaders;
    }

    public final boolean isProduceOutputHeaders() {
        return this.produceOutputHeaders;
    }

    public final void performBasicCounts() {
        if (this.outputFormat == null) {
            this.outputFormat = this.inputFormat;
        }
        this.resetStatus();
        int rc = 0;
        ReadCSV csv = new ReadCSV(this.inputFilename.toString(), this.expectInputHeaders, this.inputFormat);
        while (csv.next() && !this.cancel) {
            this.updateStatus(true);
            ++rc;
        }
        this.recordCount = rc;
        this.columnCount = csv.getColumnCount();
        this.readHeaders(csv);
        csv.close();
        this.reportDone(true);
    }

    public final PrintWriter prepareOutputFile(File outputFile) {
        try {
            PrintWriter tw = new PrintWriter(new FileWriter(outputFile));
            if (this.outputFormat == null) {
                this.outputFormat = this.inputFormat;
            }
            if (this.produceOutputHeaders) {
                int index = 0;
                StringBuilder line = new StringBuilder();
                if (this.inputHeadings != null) {
                    for (String str : this.inputHeadings) {
                        if (line.length() > 0) {
                            line.append(this.outputFormat.getSeparator());
                        }
                        line.append("\"");
                        line.append(str);
                        line.append("\"");
                        ++index;
                    }
                } else {
                    for (int i = 0; i < this.columnCount; ++i) {
                        line.append("\"field:");
                        line.append(i + 1);
                        line.append("\"");
                    }
                }
                tw.println(line.toString());
            }
            return tw;
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
    }

    public final void readHeaders(ReadCSV csv) {
        if (this.expectInputHeaders) {
            this.inputHeadings = new String[csv.getColumnNames().size()];
            for (int i = 0; i < csv.getColumnNames().size(); ++i) {
                this.inputHeadings[i] = csv.getColumnNames().get(i);
            }
        } else {
            this.inputHeadings = new String[csv.getColumnCount()];
            int i = 0;
            if (this.getScript() != null) {
                for (DataField field : this.getScript().getFields()) {
                    this.inputHeadings[i++] = field.getName();
                }
            }
            while (i < csv.getColumnCount()) {
                this.inputHeadings[i] = "field:" + i;
                ++i;
            }
        }
    }

    public final void reportDone(boolean isAnalyzing) {
        if (isAnalyzing) {
            this.report.report(this.recordCount, this.recordCount, "Done analyzing");
        } else {
            this.report.report(this.recordCount, this.recordCount, "Done processing");
        }
    }

    public final void reportDone(String task) {
        this.report.report(this.recordCount, this.recordCount, task);
    }

    @Override
    public final void requestStop() {
        this.cancel = true;
    }

    public final void resetStatus() {
        this.lastUpdate = 0;
        this.currentRecord = 0;
    }

    public final void setAnalyzed(boolean theAnalyzed) {
        this.analyzed = theAnalyzed;
    }

    public final void setColumnCount(int theColumnCount) {
        this.columnCount = theColumnCount;
    }

    public final void setExpectInputHeaders(boolean theExpectInputHeaders) {
        this.expectInputHeaders = theExpectInputHeaders;
    }

    public final void setInputFilename(File theInputFilename) {
        this.inputFilename = theInputFilename;
    }

    public final void setInputFormat(CSVFormat theInputFormat) {
        this.inputFormat = theInputFormat;
    }

    public final void setInputHeadings(String[] theInputHeadings) {
        this.inputHeadings = theInputHeadings;
    }

    public final void setOutputFormat(CSVFormat theOutputFormat) {
        this.outputFormat = theOutputFormat;
    }

    public final void setPrecision(int thePrecision) {
        this.precision = thePrecision;
    }

    public final void setProduceOutputHeaders(boolean theProduceOutputHeaders) {
        this.produceOutputHeaders = theProduceOutputHeaders;
    }

    public final void setRecordCount(int v) {
        this.recordCount = v;
    }

    public final void setReport(StatusReportable theReport) {
        this.report = theReport;
    }

    public final void setReportInterval(int theReportInterval) {
        this.reportInterval = theReportInterval;
    }

    @Override
    public final boolean shouldStop() {
        return this.cancel;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" inputFilename=");
        result.append(this.inputFilename);
        result.append(", recordCount=");
        result.append(this.recordCount);
        result.append("]");
        return result.toString();
    }

    public final void updateStatus(boolean isAnalyzing) {
        if (isAnalyzing) {
            this.updateStatus("Analyzing");
        } else {
            this.updateStatus("Processing");
        }
    }

    public final void updateStatus(String task) {
        boolean shouldDisplay = false;
        if (this.currentRecord == 0) {
            shouldDisplay = true;
        }
        ++this.currentRecord;
        ++this.lastUpdate;
        if (this.lastUpdate >= this.reportInterval) {
            this.lastUpdate = 0;
            shouldDisplay = true;
        }
        if (shouldDisplay) {
            this.report.report(this.recordCount, this.currentRecord, task);
        }
    }

    public final void validateAnalyzed() {
        if (!this.analyzed) {
            throw new QuantError("File must be analyzed first.");
        }
    }

    public final void writeRow(PrintWriter tw, LoadedRow row) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < row.getData().length; ++i) {
            BasicFile.appendSeparator(line, this.outputFormat);
            line.append(row.getData()[i]);
        }
        tw.println(line.toString());
    }

    public final AnalystScript getScript() {
        return this.script;
    }

    public final void setScript(AnalystScript theScript) {
        this.script = theScript;
    }
}

