/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.io.Serializable;
import org.encog.ml.genetic.genes.BasicGene;
import org.encog.ml.genetic.genes.Gene;
import org.encog.neural.neat.NEATNeuronType;

public class NEATNeuronGene
extends BasicGene
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ACT_RESPONSE = "aResp";
    public static final String PROPERTY_RECURRENT = "recurrent";
    public static final String PROPERTY_SPLIT_X = "splitX";
    public static final String PROPERTY_SPLIT_Y = "splitY";
    private double activationResponse;
    private NEATNeuronType neuronType;
    private boolean recurrent;
    private double splitX;
    private double splitY;

    public NEATNeuronGene() {
    }

    public NEATNeuronGene(NEATNeuronType type, long id, double splitY, double splitX) {
        this(type, id, splitY, splitX, false, 1.0);
    }

    public NEATNeuronGene(NEATNeuronType type, long id, double splitY, double splitX, boolean recurrent, double act) {
        this.neuronType = type;
        this.setId(id);
        this.splitX = splitX;
        this.splitY = splitY;
        this.recurrent = recurrent;
        this.activationResponse = act;
    }

    @Override
    public void copy(Gene gene) {
        NEATNeuronGene other = (NEATNeuronGene)gene;
        this.activationResponse = other.activationResponse;
        this.setId(other.getId());
        this.neuronType = other.neuronType;
        this.recurrent = other.recurrent;
        this.splitX = other.splitX;
        this.splitY = other.splitY;
    }

    public double getActivationResponse() {
        return this.activationResponse;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public boolean isRecurrent() {
        return this.recurrent;
    }

    public void setActivationResponse(double activationResponse) {
        this.activationResponse = activationResponse;
    }

    public void setNeuronType(NEATNeuronType neuronType) {
        this.neuronType = neuronType;
    }

    public void setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
    }

    public void setSplitX(double splitX) {
        this.splitX = splitX;
    }

    public void setSplitY(double splitY) {
        this.splitY = splitY;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATNeuronGene: id=");
        result.append(this.getId());
        result.append(", type=");
        result.append((Object)this.getNeuronType());
        result.append("]");
        return result.toString();
    }
}

