/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.training.LearningRate;
import org.encog.util.logging.EncogLogging;

public class SmartLearningRate
implements Strategy {
    public static final double LEARNING_DECAY = 0.99;
    private MLTrain train;
    private LearningRate setter;
    private double currentLearningRate;
    private long trainingSize;
    private double lastError;
    private boolean ready;

    @Override
    public final void init(MLTrain train) {
        this.train = train;
        this.ready = false;
        this.setter = (LearningRate)((Object)train);
        this.trainingSize = train.getTraining().getRecordCount();
        this.currentLearningRate = 1.0 / (double)this.trainingSize;
        EncogLogging.log(0, "Starting learning rate: " + this.currentLearningRate);
        this.setter.setLearningRate(this.currentLearningRate);
    }

    @Override
    public final void postIteration() {
        if (this.ready) {
            if (this.train.getError() > this.lastError) {
                this.currentLearningRate *= 0.99;
                this.setter.setLearningRate(this.currentLearningRate);
                EncogLogging.log(0, "Adjusting learning rate to {}" + this.currentLearningRate);
            }
        } else {
            this.ready = true;
        }
    }

    @Override
    public final void preIteration() {
        this.lastError = this.train.getError();
    }
}

