/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.arrayutil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.quant.QuantError;
import org.encog.mathutil.Equilateral;
import org.encog.util.EngineArray;
import org.encog.util.arrayutil.ClassItem;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;

public class NormalizedField {
    private double actualHigh;
    private double actualLow;
    private double normalizedHigh;
    private double normalizedLow;
    private NormalizationAction action;
    private String name;
    private final List<ClassItem> classes = new ArrayList<ClassItem>();
    private Equilateral eq;
    private final Map<String, Integer> lookup = new HashMap<String, Integer>();

    public NormalizedField() {
        this(1.0, -1.0);
    }

    public NormalizedField(double theNormalizedHigh, double theNormalizedLow) {
        this.normalizedHigh = theNormalizedHigh;
        this.normalizedLow = theNormalizedLow;
        this.actualHigh = Double.MIN_VALUE;
        this.actualLow = Double.MAX_VALUE;
        this.action = NormalizationAction.Normalize;
    }

    public NormalizedField(NormalizationAction theAction, String theName) {
        this(theAction, theName, 0.0, 0.0, 0.0, 0.0);
    }

    public NormalizedField(NormalizationAction theAction, String theName, double ahigh, double alow, double nhigh, double nlow) {
        this.action = theAction;
        this.actualHigh = ahigh;
        this.actualLow = alow;
        this.normalizedHigh = nhigh;
        this.normalizedLow = nlow;
        this.name = theName;
    }

    public NormalizedField(String theName, NormalizationAction theAction, double high, double low) {
        this.name = theName;
        this.action = theAction;
        this.normalizedHigh = high;
        this.normalizedLow = low;
    }

    public final void analyze(double d) {
        this.actualHigh = Math.max(this.actualHigh, d);
        this.actualLow = Math.min(this.actualLow, d);
    }

    public final double deNormalize(double value) {
        double result = ((this.actualLow - this.actualHigh) * value - this.normalizedHigh * this.actualLow + this.actualHigh * this.normalizedLow) / (this.normalizedLow - this.normalizedHigh);
        return result;
    }

    public final ClassItem determineClass(double[] data) {
        int resultIndex = 0;
        switch (this.action) {
            case Equilateral: {
                resultIndex = this.eq.decode(data);
                break;
            }
            case OneOf: {
                resultIndex = EngineArray.indexOfLargest(data);
                break;
            }
            case SingleField: {
                resultIndex = (int)data[0];
                break;
            }
            default: {
                throw new QuantError("Unknown action: " + (Object)((Object)this.action));
            }
        }
        return this.classes.get(resultIndex);
    }

    public final String encodeHeaders() {
        StringBuilder line = new StringBuilder();
        switch (this.action) {
            case SingleField: {
                BasicFile.appendSeparator(line, CSVFormat.EG_FORMAT);
                line.append('\"');
                line.append(this.name);
                line.append('\"');
                break;
            }
            case Equilateral: {
                for (int i = 0; i < this.classes.size() - 1; ++i) {
                    BasicFile.appendSeparator(line, CSVFormat.EG_FORMAT);
                    line.append('\"');
                    line.append(this.name);
                    line.append('-');
                    line.append(i);
                    line.append('\"');
                }
                break;
            }
            case OneOf: {
                for (int i = 0; i < this.classes.size(); ++i) {
                    BasicFile.appendSeparator(line, CSVFormat.EG_FORMAT);
                    line.append('\"');
                    line.append(this.name);
                    line.append('-');
                    line.append(i);
                    line.append('\"');
                }
                break;
            }
            default: {
                return null;
            }
        }
        return line.toString();
    }

    public final String encodeSingleField(int classNumber) {
        StringBuilder result = new StringBuilder();
        result.append(classNumber);
        return result.toString();
    }

    public final void fixSingleValue() {
        if (this.action == NormalizationAction.Normalize && Math.abs(this.actualHigh - this.actualLow) < 1.0E-13) {
            this.actualHigh += 1.0;
            this.actualLow -= 1.0;
        }
    }

    public final NormalizationAction getAction() {
        return this.action;
    }

    public final double getActualHigh() {
        return this.actualHigh;
    }

    public final double getActualLow() {
        return this.actualLow;
    }

    public final List<ClassItem> getClasses() {
        return this.classes;
    }

    public final int getColumnsNeeded() {
        switch (this.action) {
            case Ignore: {
                return 0;
            }
            case Equilateral: {
                return this.classes.size() - 1;
            }
            case OneOf: {
                return this.classes.size();
            }
        }
        return 1;
    }

    public final Equilateral getEq() {
        return this.eq;
    }

    public final String getName() {
        return this.name;
    }

    public final double getNormalizedHigh() {
        return this.normalizedHigh;
    }

    public final double getNormalizedLow() {
        return this.normalizedLow;
    }

    public final void init() {
        if (this.action == NormalizationAction.Equilateral) {
            if (this.classes.size() < 3) {
                throw new QuantError("There must be at least three classes to make use of equilateral normalization.");
            }
            this.eq = new Equilateral(this.classes.size(), this.normalizedHigh, this.normalizedLow);
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            this.lookup.put(this.classes.get(i).getName(), this.classes.get(i).getIndex());
        }
    }

    public final boolean isClassify() {
        return this.action == NormalizationAction.Equilateral || this.action == NormalizationAction.OneOf || this.action == NormalizationAction.SingleField;
    }

    public final int lookup(String str) {
        if (!this.lookup.containsKey(str)) {
            return -1;
        }
        return this.lookup.get(str);
    }

    public final void makeClass(NormalizationAction theAction, int classFrom, int classTo, int high, int low) {
        if (theAction != NormalizationAction.Equilateral && theAction != NormalizationAction.OneOf && theAction != NormalizationAction.SingleField) {
            throw new QuantError("Unsupported normalization type");
        }
        this.action = theAction;
        this.classes.clear();
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        int index = 0;
        for (int i = classFrom; i < classTo; ++i) {
            this.classes.add(new ClassItem("" + i, index++));
        }
    }

    public final void makeClass(NormalizationAction theAction, String[] cls, double high, double low) {
        if (theAction != NormalizationAction.Equilateral && theAction != NormalizationAction.OneOf && theAction != NormalizationAction.SingleField) {
            throw new QuantError("Unsupported normalization type");
        }
        this.action = theAction;
        this.classes.clear();
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        for (int i = 0; i < cls.length; ++i) {
            this.classes.add(new ClassItem(cls[i], i));
        }
    }

    public final void makePassThrough() {
        this.normalizedHigh = 0.0;
        this.normalizedLow = 0.0;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        this.action = NormalizationAction.PassThrough;
    }

    public final double normalize(double value) {
        return (value - this.actualLow) / (this.actualHigh - this.actualLow) * (this.normalizedHigh - this.normalizedLow) + this.normalizedLow;
    }

    public final void setAction(NormalizationAction theAction) {
        this.action = theAction;
    }

    public final void setActualHigh(double theActualHigh) {
        this.actualHigh = theActualHigh;
    }

    public final void setActualLow(double theActualLow) {
        this.actualLow = theActualLow;
    }

    public final void setName(String theName) {
        this.name = theName;
    }

    public final void setNormalizedHigh(double theNormalizedHigh) {
        this.normalizedHigh = theNormalizedHigh;
    }

    public final void setNormalizedLow(double theNormalizedLow) {
        this.normalizedLow = theNormalizedLow;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" name=");
        result.append(this.name);
        result.append(", actualHigh=");
        result.append(this.actualHigh);
        result.append(", actualLow=");
        result.append(this.actualLow);
        result.append("]");
        return result.toString();
    }
}

