/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.master.MasterInterceptor;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMasterCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicCoordinator<MASTER_RESULT, WORKER_RESULT>
implements MasterInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMasterCoordinator.class);
    private String myBid;

    @Override
    public void postIteration(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                block8: {
                    AbstractMasterCoordinator.this.updateMasterHaltStatus(context);
                    String workerBaseNode = null;
                    try {
                        workerBaseNode = AbstractMasterCoordinator.this.getWorkerBaseNode(context.getAppId(), context.getCurrentIteration() + 1).toString();
                        AbstractMasterCoordinator.this.getZooKeeper().createExt(workerBaseNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        LOG.warn("Node exists: {}", workerBaseNode);
                    }
                    boolean isSplit = false;
                    String appCurrentMasterNode = AbstractMasterCoordinator.this.getCurrentMasterNode(context.getAppId(), context.getCurrentIteration()).toString();
                    String appCurrentMasterSplitNode = AbstractMasterCoordinator.this.getCurrentMasterSplitNode(context.getAppId(), context.getCurrentIteration()).toString();
                    try {
                        byte[] bytes = AbstractMasterCoordinator.this.getMasterSerializer().objectToBytes(context.getMasterResult());
                        isSplit = AbstractMasterCoordinator.this.setBytesToZNode(appCurrentMasterNode, appCurrentMasterSplitNode, bytes, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        LOG.warn("Has such node:", (Throwable)e);
                    }
                    if (context.getCurrentIteration() >= 2) {
                        String znode = AbstractMasterCoordinator.this.getMasterNode(context.getAppId(), context.getCurrentIteration() - 2).toString();
                        try {
                            AbstractMasterCoordinator.this.getZooKeeper().deleteExt(znode, -1, false);
                            if (isSplit) {
                                znode = AbstractMasterCoordinator.this.getCurrentMasterSplitNode(context.getAppId(), context.getCurrentIteration() - 2).toString();
                                AbstractMasterCoordinator.this.getZooKeeper().deleteExt(znode, -1, true);
                            }
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 20L != 0L) break block8;
                            LOG.warn("No such node:{}", (Object)znode);
                        }
                    }
                }
                LOG.info("master results write to znode.");
            }
        }.execute();
    }

    @Override
    public void postApplication(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                try {
                    String zkCleanUpEnabled = StringUtils.get(context.getProps().getProperty("guagua.zk.cleanup.enable"), "true");
                    String appId = context.getAppId();
                    boolean isLastMaster = true;
                    if (NumberFormatUtils.getInt(context.getProps().getProperty("guagua.master.number"), 1) > 1) {
                        String masterElectionPath = AbstractMasterCoordinator.this.getBaseMasterElectionNode(appId).toString();
                        List<String> masterElectionNodes = AbstractMasterCoordinator.this.getZooKeeper().getChildrenExt(masterElectionPath, false, true, true);
                        isLastMaster = this.isLastMaster(masterElectionNodes);
                    }
                    if (isLastMaster && Boolean.TRUE.toString().equalsIgnoreCase(zkCleanUpEnabled)) {
                        final int currentIteration = context.getCurrentIteration();
                        final int workers = context.getWorkers();
                        final String endWorkersNode = AbstractMasterCoordinator.this.getWorkerBaseNode(appId, currentIteration).toString();
                        new BasicCoordinator.RetryCoordinatorCommand(AbstractMasterCoordinator.this.isFixedTime(), AbstractMasterCoordinator.this.getSleepTime()){

                            @Override
                            public boolean retryExecution() throws KeeperException, InterruptedException {
                                try {
                                    List<String> workerChildern = AbstractMasterCoordinator.this.getZooKeeper().getChildrenExt(endWorkersNode, false, false, true);
                                    int workersEndCompleted = workerChildern.size();
                                    if (System.nanoTime() % 10L == 0L) {
                                        LOG.info("iteration {}, workers ended: {}, still {} workers are not synced.", new Object[]{currentIteration, workersEndCompleted, workers - workersEndCompleted});
                                    }
                                    return workers == workersEndCompleted;
                                }
                                catch (KeeperException.NoNodeException e) {
                                    if (System.nanoTime() % 10L == 0L) {
                                        LOG.warn("No such node:{}", (Object)endWorkersNode);
                                    }
                                    return false;
                                }
                            }
                        }.execute();
                        String appNode = AbstractMasterCoordinator.this.getAppNode(appId).toString();
                        try {
                            AbstractMasterCoordinator.this.getZooKeeper().deleteExt(appNode, -1, true);
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 20L == 0L) {
                                LOG.warn("No such node:{}", (Object)appNode);
                            }
                        }
                    }
                }
                finally {
                    AbstractMasterCoordinator.this.closeZooKeeper();
                }
            }

            private boolean isLastMaster(List<String> masterElectionNodes) {
                return masterElectionNodes == null || masterElectionNodes.size() == 0 || masterElectionNodes.get(masterElectionNodes.size() - 1).equals(AbstractMasterCoordinator.this.getMyBid());
            }
        }.execute();
    }

    protected void setWorkerResults(final MasterContext<MASTER_RESULT, WORKER_RESULT> context, final String appCurrentWorkersNode, final String appId, final int iteration) throws KeeperException, InterruptedException {
        if (context.getCurrentIteration() == 0) {
            return;
        }
        final List<String> workerChildern = this.getZooKeeper().getChildrenExt(appCurrentWorkersNode, false, false, false);
        context.setWorkerResults(new Iterable<WORKER_RESULT>(){

            @Override
            public Iterator<WORKER_RESULT> iterator() {
                return new Iterator<WORKER_RESULT>(){
                    private Iterator<String> itr;
                    private volatile AtomicBoolean isStart = new AtomicBoolean();

                    @Override
                    public boolean hasNext() {
                        boolean hasNext;
                        if (this.isStart.compareAndSet(false, true)) {
                            this.itr = workerChildern.iterator();
                        }
                        if (!(hasNext = this.itr.hasNext())) {
                            this.itr = workerChildern.iterator();
                            return false;
                        }
                        return hasNext;
                    }

                    @Override
                    public WORKER_RESULT next() {
                        String worker = this.itr.next();
                        String appCurrentWorkerSplitNode = AbstractMasterCoordinator.this.getCurrentWorkerSplitNode(appId, worker, iteration).toString();
                        byte[] data = null;
                        try {
                            data = AbstractMasterCoordinator.this.getBytesFromZNode(appCurrentWorkersNode + "/" + worker, appCurrentWorkerSplitNode);
                        }
                        catch (KeeperException e) {
                            throw new GuaguaRuntimeException(e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        if (data != null) {
                            Object workerResult = AbstractMasterCoordinator.this.getWorkerSerializer().bytesToObject(data, context.getWorkerResultClassName());
                            return workerResult;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    protected void updateMasterHaltStatus(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        MASTER_RESULT result = context.getMasterResult();
        if (Boolean.TRUE.toString().equalsIgnoreCase(context.getProps().getProperty("guagua.worker.halt.enable", "false")) && this.isAllWorkersHalt(context.getWorkerResults()) && result instanceof HaltBytable) {
            ((HaltBytable)result).setHalt(true);
            context.setMasterResult(result);
        }
    }

    protected boolean isAllWorkersHalt(Iterable<WORKER_RESULT> workerResults) {
        boolean isHasWorkerResults = false;
        for (Bytable workerResult : workerResults) {
            isHasWorkerResults = true;
            if (workerResult instanceof HaltBytable && ((HaltBytable)workerResult).isHalt()) continue;
            return false;
        }
        return isHasWorkerResults;
    }

    public String getMyBid() {
        return this.myBid;
    }

    public void setMyBid(String myBid) {
        this.myBid = myBid;
    }

    protected class MasterElectionCommand
    extends BasicCoordinator.BasicCoordinatorCommand {
        private final String appId;

        public MasterElectionCommand(String appId) {
            this.appId = appId;
        }

        @Override
        public void doExecute() throws KeeperException, InterruptedException {
            final String masterElectionPath = AbstractMasterCoordinator.this.getBaseMasterElectionNode(this.appId).toString();
            String masterElectionNode = AbstractMasterCoordinator.this.getMasterElectionNode(this.appId, AbstractMasterCoordinator.this.getZooKeeper().getZooKeeper().getSessionId()).toString();
            try {
                AbstractMasterCoordinator.this.getZooKeeper().createExt(masterElectionPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.NodeExistsException e) {
                LOG.warn("Node exists: {}", (Object)masterElectionPath);
            }
            AbstractMasterCoordinator.this.setMyBid(AbstractMasterCoordinator.this.getZooKeeper().createExt(masterElectionNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, true));
            new BasicCoordinator.RetryCoordinatorCommand(AbstractMasterCoordinator.this.isFixedTime(), AbstractMasterCoordinator.this.getSleepTime()){

                @Override
                public boolean retryExecution() throws KeeperException, InterruptedException {
                    List<String> masterChildArr = AbstractMasterCoordinator.this.getZooKeeper().getChildrenExt(masterElectionPath, false, true, true);
                    if (System.nanoTime() % 20L == 0L) {
                        LOG.info("becomeMaster: First child is '{}' and my bid is '{}'", (Object)masterChildArr.get(0), (Object)AbstractMasterCoordinator.this.getMyBid());
                    }
                    return masterChildArr.get(0).equals(AbstractMasterCoordinator.this.getMyBid());
                }
            }.execute();
            LOG.info("Become master.");
        }
    }

    protected class FailOverCommand
    extends BasicCoordinator.BasicCoordinatorCommand {
        private final MasterContext<MASTER_RESULT, WORKER_RESULT> context;

        public FailOverCommand(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
            this.context = context;
        }

        @Override
        public void doExecute() throws KeeperException, InterruptedException {
            String masterBaseNode = AbstractMasterCoordinator.this.getMasterBaseNode(this.context.getAppId()).toString();
            List<String> masterIterations = null;
            try {
                masterIterations = AbstractMasterCoordinator.this.getZooKeeper().getChildrenExt(masterBaseNode, false, false, false);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn("No such node:{}", (Object)masterBaseNode);
            }
            if (masterIterations != null && masterIterations.size() > 0) {
                Collections.sort(masterIterations, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
                    }
                });
                LOG.info("DEBUG: master children:{}", masterIterations);
                try {
                    int restartedIteration = Integer.valueOf(masterIterations.get(masterIterations.size() - 1));
                    this.context.setCurrentIteration(restartedIteration);
                    LOG.info("Container {} restarted at: {} step.", (Object)this.context.getContainerId(), (Object)restartedIteration);
                }
                catch (NumberFormatException e) {
                    this.context.setCurrentIteration(0);
                }
            }
        }
    }
}

