/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.io.Serializable;
import org.encog.ml.genetic.genes.BasicGene;
import org.encog.ml.genetic.genes.Gene;

public class NEATLinkGene
extends BasicGene
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long fromNeuronID;
    private boolean recurrent;
    private long toNeuronID;
    private double weight;

    public NEATLinkGene() {
    }

    public NEATLinkGene(long fromNeuronID, long toNeuronID, boolean enabled, long innovationID, double weight, boolean recurrent) {
        this.fromNeuronID = fromNeuronID;
        this.toNeuronID = toNeuronID;
        this.setEnabled(enabled);
        this.setInnovationId(innovationID);
        this.weight = weight;
        this.recurrent = recurrent;
    }

    @Override
    public void copy(Gene gene) {
        NEATLinkGene other = (NEATLinkGene)gene;
        this.setEnabled(other.isEnabled());
        this.fromNeuronID = other.fromNeuronID;
        this.toNeuronID = other.toNeuronID;
        this.setInnovationId(other.getInnovationId());
        this.recurrent = other.recurrent;
        this.weight = other.weight;
    }

    public long getFromNeuronID() {
        return this.fromNeuronID;
    }

    public long getToNeuronID() {
        return this.toNeuronID;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isRecurrent() {
        return this.recurrent;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATLinkGene:innov=");
        result.append(this.getInnovationId());
        result.append(",enabled=");
        result.append(this.isEnabled());
        result.append(",from=");
        result.append(this.fromNeuronID);
        result.append(",to=");
        result.append(this.toNeuronID);
        result.append("]");
        return result.toString();
    }

    public void setFromNeuronID(int i) {
        this.fromNeuronID = i;
    }

    public void setToNeuronID(int i) {
        this.toNeuronID = i;
    }

    public void setRecurrent(boolean b) {
        this.recurrent = b;
    }
}

