/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;
import org.encog.neural.networks.BasicNetwork;

public abstract class TrainingJob {
    private BasicNetwork network;
    private MLDataSet training;
    private final List<Strategy> strategies = new ArrayList<Strategy>();
    private boolean loadToMemory;
    private MLTrain train;
    private Throwable error;

    public TrainingJob(BasicNetwork network, MLDataSet training, boolean loadToMemory) {
        this.network = network;
        this.training = training;
        this.loadToMemory = loadToMemory;
    }

    public abstract void createTrainer(boolean var1);

    public final Throwable getError() {
        return this.error;
    }

    public final BasicNetwork getNetwork() {
        return this.network;
    }

    public final List<Strategy> getStrategies() {
        return this.strategies;
    }

    public final MLTrain getTrain() {
        return this.train;
    }

    public final MLDataSet getTraining() {
        return this.training;
    }

    public final boolean isLoadToMemory() {
        return this.loadToMemory;
    }

    public final void setError(Throwable error) {
        this.error = error;
    }

    public final void setLoadToMemory(boolean loadToMemory) {
        this.loadToMemory = loadToMemory;
    }

    public final void setNetwork(BasicNetwork network) {
        this.network = network;
    }

    public final void setTrain(MLTrain train) {
        this.train = train;
    }

    public final void setTraining(MLDataSet training) {
        this.training = training;
    }

    public final boolean shouldContinue() {
        for (Strategy strategy : this.train.getStrategies()) {
            EndTrainingStrategy end;
            if (!(strategy instanceof EndTrainingStrategy) || !(end = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return false;
        }
        return true;
    }
}

