/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.pnn;

import org.encog.neural.networks.training.pnn.CalculationCriteria;

public class GlobalMinimumSearch {
    public static final double CGOLD = 0.381966;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private double x3;
    private double y3;

    public final double brentmin(int maxIterations, double maxError, double eps, double tol, CalculationCriteria network, double y) {
        double prevdist = 0.0;
        double step = 0.0;
        double xbest = this.x2;
        double x2ndBest = this.x2;
        double x3rdBest = this.x2;
        double xlow = this.x1;
        double xhigh = this.x3;
        double fbest = y;
        double fsecbest = y;
        double fthirdbest = y;
        for (int iter = 0; iter < maxIterations && !(fbest < maxError); ++iter) {
            double xmid = 0.5 * (xlow + xhigh);
            double tol1 = tol * (Math.abs(xbest) + eps);
            double tol2 = 2.0 * tol1;
            if (Math.abs(xbest - xmid) <= tol2 - 0.5 * (xhigh - xlow) || iter >= 2 && fthirdbest - fbest < eps) break;
            double xrecent = 0.0;
            if (Math.abs(prevdist) > tol1) {
                double t1 = (xbest - x2ndBest) * (fbest - fthirdbest);
                double t2 = (xbest - x3rdBest) * (fbest - fsecbest);
                double numer = (xbest - x3rdBest) * t2 - (xbest - x2ndBest) * t1;
                double denom = 2.0 * (t1 - t2);
                double testdist = prevdist;
                prevdist = step;
                step = denom != 0.0 ? numer / denom : 1.0E30;
                if (Math.abs(step) < Math.abs(0.5 * testdist) && step + xbest > xlow && step + xbest < xhigh) {
                    xrecent = xbest + step;
                    if (xrecent - xlow < tol2 || xhigh - xrecent < tol2) {
                        step = xbest < xmid ? tol1 : -tol1;
                    }
                } else {
                    prevdist = xbest >= xmid ? xlow - xbest : xhigh - xbest;
                    step = 0.381966 * prevdist;
                }
            } else {
                prevdist = xbest >= xmid ? xlow - xbest : xhigh - xbest;
                step = 0.381966 * prevdist;
            }
            xrecent = Math.abs(step) >= tol1 ? xbest + step : (step > 0.0 ? xbest + tol1 : xbest - tol1);
            double frecent = network.calcErrorWithSingleSigma(xrecent);
            if (frecent < 0.0) break;
            if (frecent <= fbest) {
                if (xrecent >= xbest) {
                    xlow = xbest;
                } else {
                    xhigh = xbest;
                }
                x3rdBest = x2ndBest;
                x2ndBest = xbest;
                xbest = xrecent;
                fthirdbest = fsecbest;
                fsecbest = fbest;
                fbest = frecent;
                continue;
            }
            if (xrecent < xbest) {
                xlow = xrecent;
            } else {
                xhigh = xrecent;
            }
            if (frecent <= fsecbest || x2ndBest == xbest) {
                x3rdBest = x2ndBest;
                x2ndBest = xrecent;
                fthirdbest = fsecbest;
                fsecbest = frecent;
                continue;
            }
            if (!(frecent <= fthirdbest) && x3rdBest != xbest && x3rdBest != x2ndBest) continue;
            x3rdBest = xrecent;
            fthirdbest = frecent;
        }
        this.x1 = xlow;
        this.x2 = xbest;
        this.x3 = xhigh;
        return fbest;
    }

    public final void findBestRange(double low, double high, int numberOfPoints, boolean useLog, double minError, CalculationCriteria network) {
        boolean firstPointKnown;
        if (numberOfPoints < 0) {
            numberOfPoints = -numberOfPoints;
            firstPointKnown = true;
        } else {
            firstPointKnown = false;
        }
        double rate = useLog ? Math.exp(Math.log(high / low) / (double)(numberOfPoints - 1)) : (high - low) / (double)(numberOfPoints - 1);
        double x = low;
        double previous = 0.0;
        int ibest = -1;
        boolean gettingWorse = false;
        for (int i = 0; i < numberOfPoints; ++i) {
            double y = i > 0 || !firstPointKnown ? network.calcErrorWithSingleSigma(x) : this.y2;
            if (i == 0 || y < this.y2) {
                ibest = i;
                this.x2 = x;
                this.y2 = y;
                this.y1 = previous;
                gettingWorse = false;
            } else if (i == ibest + 1) {
                this.y3 = y;
                gettingWorse = true;
            }
            previous = y;
            if (this.y2 <= minError && ibest > 0 && gettingWorse) break;
            if (useLog) {
                x *= rate;
                continue;
            }
            x += rate;
        }
        if (useLog) {
            this.x1 = this.x2 / rate;
            this.x3 = this.x2 * rate;
        } else {
            this.x1 = this.x2 - rate;
            this.x3 = this.x2 + rate;
        }
        if (!gettingWorse) {
            while (true) {
                this.y3 = network.calcErrorWithSingleSigma(this.x3);
                if (!(this.y3 > this.y2 || this.y1 == this.y2 && this.y2 == this.y3)) {
                    this.x1 = this.x2;
                    this.y1 = this.y2;
                    this.x2 = this.x3;
                    this.y2 = this.y3;
                    rate *= 3.0;
                    if (useLog) {
                        this.x3 *= rate;
                        continue;
                    }
                    this.x3 += rate;
                    continue;
                }
                break;
            }
        } else if (ibest == 0) {
            while (true) {
                this.y1 = network.calcErrorWithSingleSigma(this.x1);
                if (this.y1 < 0.0) {
                    return;
                }
                if (this.y1 > this.y2 || this.y1 == this.y2 && this.y2 == this.y3) break;
                this.x3 = this.x2;
                this.y3 = this.y2;
                this.x2 = this.x1;
                this.y2 = this.y1;
                rate *= 3.0;
                if (useLog) {
                    this.x1 /= rate;
                    continue;
                }
                this.x1 -= rate;
            }
        }
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getX3() {
        return this.x3;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getY2() {
        return this.y2;
    }

    public final double getY3() {
        return this.y3;
    }

    public final void setX1(double x1) {
        this.x1 = x1;
    }

    public final void setX2(double x2) {
        this.x2 = x2;
    }

    public final void setX3(double x3) {
        this.x3 = x3;
    }

    public final void setY1(double y1) {
        this.y1 = y1;
    }

    public final void setY2(double y2) {
        this.y2 = y2;
    }

    public final void setY3(double y3) {
        this.y3 = y3;
    }
}

