/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn.example.nn;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import ml.shifu.guagua.master.BasicMasterInterceptor;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.yarn.example.nn.NNUtils;
import ml.shifu.guagua.yarn.example.nn.meta.NNParams;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.encog.neural.networks.BasicNetwork;
import org.encog.persist.EncogDirectoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNOutput
extends BasicMasterInterceptor<NNParams, NNParams> {
    private static final Logger LOG = LoggerFactory.getLogger(NNOutput.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postApplication(MasterContext<NNParams, NNParams> context) {
        LOG.info("NNOutput starts to write model to files.");
        int inputs = NumberFormatUtils.getInt((String)context.getProps().getProperty("guagua.nn.input.nodes"), (int)100);
        int hiddens = NumberFormatUtils.getInt((String)context.getProps().getProperty("guagua.nn.hidden.nodes"), (int)2);
        int outputs = NumberFormatUtils.getInt((String)context.getProps().getProperty("guagua.nn.output.nodes"), (int)1);
        BasicNetwork network = NNUtils.generateNetwork(inputs, hiddens, outputs);
        Path out = new Path(context.getProps().getProperty("guagua.nn.output"));
        FSDataOutputStream fos = null;
        try {
            fos = FileSystem.get((Configuration)new Configuration()).create(out);
            LOG.info("Writing results to {}", (Object)out.toString());
            network.getFlat().setWeights(((NNParams)context.getMasterResult()).getWeights());
            EncogDirectoryPersistence.saveObject((OutputStream)fos, (Object)network);
        }
        catch (IOException e) {
            try {
                LOG.error("Error in writing output.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(fos);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)fos);
        }
        IOUtils.closeStream((Closeable)fos);
    }
}

