/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize.output;

import org.encog.util.normalize.input.InputField;
import org.encog.util.normalize.output.BasicOutputField;
import org.encog.util.normalize.output.RequireTwoPass;

public class OutputFieldRangeMapped
extends BasicOutputField
implements RequireTwoPass {
    private InputField field;
    private double low;
    private double high;

    public static double calculate(double value, double min, double max, double hi, double lo) {
        return (value - min) / (max - min) * (hi - lo) + lo;
    }

    public OutputFieldRangeMapped() {
    }

    public OutputFieldRangeMapped(InputField field, double low, double high) {
        this.field = field;
        this.low = low;
        this.high = high;
    }

    public OutputFieldRangeMapped(InputField f) {
        this(f, -1.0, 1.0);
    }

    @Override
    public double calculate(int subfield) {
        return (this.field.getCurrentValue() - this.field.getMin()) / (this.field.getMax() - this.field.getMin()) * (this.high - this.low) + this.low;
    }

    public InputField getField() {
        return this.field;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    @Override
    public int getSubfieldCount() {
        return 1;
    }

    @Override
    public void rowInit() {
    }

    public double convertBack(double data) {
        double result = ((this.field.getMin() - this.field.getMax()) * data - this.high * this.field.getMin() + this.field.getMax() * this.low) / (this.low - this.high);
        return result;
    }
}

