/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.BytableWrapper;
import ml.shifu.guagua.io.NettyBytableDecoder;
import ml.shifu.guagua.io.NettyBytableEncoder;
import ml.shifu.guagua.master.AbstractMasterCoordinator;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.util.BytableDiskList;
import ml.shifu.guagua.util.BytableMemoryDiskList;
import ml.shifu.guagua.util.NetworkUtils;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.util.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyMasterCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractMasterCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyMasterCoordinator.class);
    private ServerBootstrap messageServer;
    private int messageServerPort;
    private static final Object LOCK = new Object();
    private BytableMemoryDiskList<BytableWrapper> iterResults;
    private Map<String, Integer> indexMap = Collections.synchronizedMap(new HashMap());
    private int currentInteration;

    @Override
    protected void initialize(Properties props) {
        super.initialize(props);
        this.initIterResults(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIterResults(Properties props) {
        Object object = LOCK;
        synchronized (object) {
            BytableDiskList bytableDiskList = new BytableDiskList(System.currentTimeMillis() + "", BytableWrapper.class.getName());
            double memoryFraction = Double.valueOf(props.getProperty("guagua.master.workeresults.memoryFraction", "0.6"));
            long memoryStoreSize = (long)((double)Runtime.getRuntime().maxMemory() * memoryFraction);
            this.iterResults = new BytableMemoryDiskList(memoryStoreSize, bytableDiskList);
        }
    }

    @Override
    public void preApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        new AbstractMasterCoordinator.FailOverCommand(context).execute();
        try {
            this.startNettyServer(context.getProps());
        }
        catch (UnknownHostException e) {
            throw new GuaguaRuntimeException(e);
        }
        this.currentInteration = context.isInitIteration() ? 1 : context.getCurrentIteration();
        this.initMasterZnode(context);
        if (!context.isInitIteration()) {
            return;
        }
        this.clear(context.getProps());
        LOG.info("All workers are initiliazed successfully.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(Properties props) {
        Object object = LOCK;
        synchronized (object) {
            this.iterResults.close();
            this.iterResults.clear();
            this.initIterResults(props);
            this.indexMap.clear();
        }
    }

    private void initMasterZnode(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        String znode = null;
        try {
            znode = this.getMasterBaseNode(context.getAppId()).toString();
            this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn("Node exists: {}", (Object)znode);
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
        try {
            znode = this.getCurrentMasterNode(context.getAppId(), 0).toString();
            if (this.getZooKeeper().exists(znode, false) == null) {
                String znodeValue = InetAddress.getLocalHost().getHostName() + ":" + this.messageServerPort + ":" + 1;
                this.getZooKeeper().createExt(znode, znodeValue.getBytes(Charset.forName("UTF-8")), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                LOG.info("Master znode initialization with server info {}", (Object)znodeValue);
            } else {
                String existZnodeValue = new String(this.getZooKeeper().getData(znode, null, null), Charset.forName("UTF-8"));
                int version = NumberFormatUtils.getInt(existZnodeValue.split(":")[2], true);
                String znodeValue = InetAddress.getLocalHost().getHostName() + ":" + this.messageServerPort + ":" + (version + 1);
                this.getZooKeeper().createOrSetExt(znode, znodeValue.getBytes(Charset.forName("UTF-8")), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false, -1);
                LOG.info("Master znode re-initialization with server info {}", (Object)znodeValue);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn("Node exists: {}", (Object)znode);
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
    }

    private void startNettyServer(Properties props) throws UnknownHostException {
        this.messageServerPort = NumberFormatUtils.getInt(props.getProperty("guagua.netty.sever.port"), 44323);
        this.messageServerPort = NetworkUtils.getValidServerPort(this.messageServerPort);
        this.messageServer = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newFixedThreadPool(8), (Executor)Executors.newCachedThreadPool(new MasterThreadFactory())));
        this.messageServer.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new NettyBytableEncoder(), new NettyBytableDecoder(), new ServerHandler()});
            }
        });
        try {
            this.messageServer.bind((SocketAddress)new InetSocketAddress(this.messageServerPort));
        }
        catch (ChannelException e) {
            LOG.warn(e.getMessage() + "; try to rebind again.");
            this.messageServerPort = NetworkUtils.getValidServerPort(this.messageServerPort);
            this.messageServer.bind((SocketAddress)new InetSocketAddress(this.messageServerPort));
        }
        LOG.info("Master netty server is started at {}", (Object)(InetAddress.getLocalHost().getHostName() + ":" + InetAddress.getLocalHost().getHostAddress() + ":" + this.messageServerPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preIteration(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.currentInteration = context.getCurrentIteration();
        long start = System.nanoTime();
        new BasicCoordinator.RetryCoordinatorCommand(this.isFixedTime(), this.getSleepTime()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean retryExecution() throws KeeperException, InterruptedException {
                int doneWorkers;
                Object object = LOCK;
                synchronized (object) {
                    doneWorkers = (int)NettyMasterCoordinator.this.iterResults.size();
                }
                if (System.nanoTime() % 30L == 0L) {
                    LOG.info("iteration {}, workers compelted: {}, still {} workers are not synced.", new Object[]{context.getCurrentIteration(), doneWorkers, context.getWorkers() - doneWorkers});
                }
                return this.isTerminated(doneWorkers, context.getWorkers(), context.getMinWorkersRatio(), context.getMinWorkersTimeOut());
            }
        }.execute();
        Object object = LOCK;
        synchronized (object) {
            this.iterResults.switchState();
        }
        context.setWorkerResults(new Iterable<WORKER_RESULT>(){

            @Override
            public Iterator<WORKER_RESULT> iterator() {
                return new Iterator<WORKER_RESULT>(){
                    private Iterator<BytableWrapper> localItr;
                    private volatile AtomicBoolean isStart = new AtomicBoolean();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        boolean hasNext;
                        Object object = LOCK;
                        synchronized (object) {
                            if (this.isStart.compareAndSet(false, true)) {
                                this.localItr = NettyMasterCoordinator.this.iterResults.iterator();
                            }
                            if (!(hasNext = this.localItr.hasNext())) {
                                this.localItr = NettyMasterCoordinator.this.iterResults.iterator();
                                return false;
                            }
                        }
                        return hasNext;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public WORKER_RESULT next() {
                        Object object = LOCK;
                        synchronized (object) {
                            return NettyMasterCoordinator.this.getWorkerSerializer().bytesToObject(this.localItr.next().getBytes(), context.getWorkerResultClassName());
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
    }

    @Override
    public void postIteration(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                block6: {
                    NettyMasterCoordinator.this.updateMasterHaltStatus(context);
                    NettyMasterCoordinator.this.clear(context.getProps());
                    boolean isSplit = false;
                    String appCurrentMasterNode = NettyMasterCoordinator.this.getCurrentMasterNode(context.getAppId(), context.getCurrentIteration()).toString();
                    String appCurrentMasterSplitNode = NettyMasterCoordinator.this.getCurrentMasterSplitNode(context.getAppId(), context.getCurrentIteration()).toString();
                    LOG.debug("master result:{}", context.getMasterResult());
                    try {
                        byte[] bytes = NettyMasterCoordinator.this.getMasterSerializer().objectToBytes(context.getMasterResult());
                        isSplit = NettyMasterCoordinator.this.setBytesToZNode(appCurrentMasterNode, appCurrentMasterSplitNode, bytes, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        LOG.warn("Has such node:", (Throwable)e);
                    }
                    if (context.getCurrentIteration() >= 3) {
                        String znode = NettyMasterCoordinator.this.getMasterNode(context.getAppId(), context.getCurrentIteration() - 2).toString();
                        try {
                            NettyMasterCoordinator.this.getZooKeeper().deleteExt(znode, -1, false);
                            if (isSplit) {
                                znode = NettyMasterCoordinator.this.getCurrentMasterSplitNode(context.getAppId(), context.getCurrentIteration() - 2).toString();
                                NettyMasterCoordinator.this.getZooKeeper().deleteExt(znode, -1, true);
                            }
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 20L != 0L) break block6;
                            LOG.warn("No such node:{}", (Object)znode);
                        }
                    }
                }
                LOG.info("master results write to znode.");
            }
        }.execute();
    }

    @Override
    public void postApplication(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.currentInteration = context.getCurrentIteration();
        new BasicCoordinator.BasicCoordinatorCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doExecute() throws Exception, InterruptedException {
                try {
                    String zkCleanUpEnabled = StringUtils.get(context.getProps().getProperty("guagua.zk.cleanup.enable"), "true");
                    if (Boolean.TRUE.toString().equalsIgnoreCase(zkCleanUpEnabled)) {
                        new BasicCoordinator.RetryCoordinatorCommand(NettyMasterCoordinator.this.isFixedTime(), NettyMasterCoordinator.this.getSleepTime()){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public boolean retryExecution() throws KeeperException, InterruptedException {
                                int doneWorkers;
                                Object object = LOCK;
                                synchronized (object) {
                                    doneWorkers = (int)NettyMasterCoordinator.this.iterResults.size();
                                }
                                if (System.nanoTime() % 30L == 0L) {
                                    LOG.info("unregister step, worker(s) compelted: {}, still {} workers are not unregistered.", (Object)doneWorkers, (Object)(context.getWorkers() - doneWorkers));
                                }
                                return this.isTerminated(doneWorkers, context.getWorkers(), context.getMinWorkersRatio(), context.getMinWorkersTimeOut());
                            }
                        }.execute();
                        String appNode = NettyMasterCoordinator.this.getAppNode(context.getAppId()).toString();
                        try {
                            NettyMasterCoordinator.this.getZooKeeper().deleteExt(appNode, -1, true);
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 20L == 0L) {
                                LOG.warn("No such node:{}", (Object)appNode);
                            }
                        }
                    }
                }
                finally {
                    if (NettyMasterCoordinator.this.messageServer != null) {
                        Method shutDownMethod = ReflectionUtils.getMethod(NettyMasterCoordinator.this.messageServer.getClass(), "shutdown");
                        if (shutDownMethod != null) {
                            shutDownMethod.invoke((Object)NettyMasterCoordinator.this.messageServer, (Object[])null);
                        }
                        NettyMasterCoordinator.this.messageServer.releaseExternalResources();
                    }
                    NettyMasterCoordinator.super.closeZooKeeper();
                    NettyMasterCoordinator.this.iterResults.close();
                    NettyMasterCoordinator.this.iterResults.clear();
                }
            }
        }.execute();
    }

    private class ServerHandler
    extends SimpleChannelUpstreamHandler {
        private ServerHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof ChannelStateEvent && ((ChannelStateEvent)e).getState() != ChannelState.INTEREST_OPS) {
                LOG.debug(e.toString());
            }
            super.handleUpstream(ctx, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            if (!(e.getMessage() instanceof Bytable)) {
                throw new IllegalStateException("Message should be bytable instance.");
            }
            BytableWrapper bytableWrapper = (BytableWrapper)e.getMessage();
            LOG.debug("Received container id {} with message:{}", (Object)bytableWrapper.getContainerId(), (Object)bytableWrapper);
            String containerId = bytableWrapper.getContainerId();
            Object object = LOCK;
            synchronized (object) {
                if (bytableWrapper.isStopMessage()) {
                    if (!NettyMasterCoordinator.this.indexMap.containsKey(containerId)) {
                        NettyMasterCoordinator.this.iterResults.append(bytableWrapper);
                        NettyMasterCoordinator.this.indexMap.put(containerId, (int)(NettyMasterCoordinator.this.iterResults.size() - 1L));
                    }
                } else if (!NettyMasterCoordinator.this.indexMap.containsKey(containerId) && NettyMasterCoordinator.this.currentInteration == bytableWrapper.getCurrentIteration()) {
                    NettyMasterCoordinator.this.iterResults.append(bytableWrapper);
                    NettyMasterCoordinator.this.indexMap.put(containerId, (int)(NettyMasterCoordinator.this.iterResults.size() - 1L));
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            e.getChannel().close();
        }
    }

    private static class MasterThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        MasterThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.warn("Error message in thread {} with error message {}, error root cause {}.", new Object[]{t, e, e.getCause()});
                }
            });
            return t;
        }
    }
}

