/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.mapreduce.example.nn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ml.shifu.guagua.hadoop.io.GuaguaInputSplit;
import ml.shifu.guagua.mapreduce.GuaguaMRRecordReader;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NNInputFormat
extends TextInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(NNInputFormat.class);

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List splits = super.getSplits(job);
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>();
        for (int i = 0; i < job.getConfiguration().getInt("nn.test.scale", 1); ++i) {
            for (InputSplit inputSplit : splits) {
                if (!this.isNotPigOrHadoopMetaFile(((FileSplit)inputSplit).getPath())) continue;
                newSplits.add((InputSplit)new GuaguaInputSplit(false, new FileSplit[]{(FileSplit)inputSplit}));
            }
        }
        newSplits.add((InputSplit)new GuaguaInputSplit(true, (FileSplit)null));
        int mapperSize = newSplits.size();
        LOG.info("inputs size including master: {}", (Object)mapperSize);
        LOG.debug("input splits inclduing: {}", newSplits);
        job.getConfiguration().set("guagua.worker.number", mapperSize - 1 + "");
        return newSplits;
    }

    protected boolean isNotPigOrHadoopMetaFile(Path path) {
        return path.toString().indexOf("_SUCCESS") < 0 && path.toString().indexOf("pig_header") < 0 && path.toString().indexOf("pig_schema") < 0;
    }

    protected boolean isSplitable(JobContext context, Path file) {
        if (file.getName().endsWith("bz2")) {
            return true;
        }
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return codec == null;
    }

    public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new GuaguaMRRecordReader(context.getConfiguration().getInt("guagua.iteration.count", -1));
    }
}

