/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.util.ProgressLock;
import ml.shifu.guagua.worker.AbstractWorkerCoordinator;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWorkerCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractWorkerCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncWorkerCoordinator.class);
    private int currentIteration;
    private String appId;
    protected ProgressLock masterInitLock = new ProgressLock();
    protected ProgressLock masterIterationLock = new ProgressLock();

    @Override
    public void process(WatchedEvent event) {
        LOG.info("DEBUG: process: Got a new event, path = {}, type = {}, state = {}", new Object[]{event.getPath(), event.getType(), event.getState()});
        if (event.getPath() == null && event.getType() == Watcher.Event.EventType.None) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                LOG.info("process: Asynchronous connection complete.");
                super.getZkConnLatch().countDown();
            } else {
                LOG.warn("process: Got unknown null path event " + event);
            }
            return;
        }
        String appMasterNode = this.getCurrentMasterNode(this.getAppId(), this.getCurrentIteration()).toString();
        if (event.getPath().equals(appMasterNode) && (event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeDataChanged)) {
            if (this.getCurrentIteration() == 0) {
                this.masterInitLock.signal();
            } else {
                this.masterIterationLock.signal();
            }
        }
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void preApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        this.setAppId(context.getAppId());
        new AbstractWorkerCoordinator.FailOverCoordinatorCommand(context).execute();
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appId = context.getAppId();
                int currentIteration = context.getCurrentIteration();
                String containerId = context.getContainerId();
                String appMasterNode = AsyncWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                Stat stat = null;
                String znode = null;
                try {
                    znode = AsyncWorkerCoordinator.this.getRootNode().toString();
                    stat = AsyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        AsyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = AsyncWorkerCoordinator.this.getAppNode(appId).toString();
                    stat = AsyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        AsyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = AsyncWorkerCoordinator.this.getWorkerBaseNode(appId).toString();
                    stat = AsyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        AsyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = AsyncWorkerCoordinator.this.getWorkerBaseNode(appId, currentIteration).toString();
                    stat = AsyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        AsyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = AsyncWorkerCoordinator.this.getCurrentWorkerNode(appId, containerId, currentIteration).toString();
                    AsyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                stat = AsyncWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, true);
                if (stat == null) {
                    LOG.info("DEBUG: wait for {}.", (Object)appMasterNode);
                    AsyncWorkerCoordinator.this.masterInitLock.waitForever();
                    AsyncWorkerCoordinator.this.masterInitLock.reset();
                }
                if (context.getCurrentIteration() != 0) {
                    String appMasterSplitNode = AsyncWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                    AsyncWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                }
                LOG.info("Master initilization is done.");
            }
        }.execute();
    }

    @Override
    public void preIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.setCurrentIteration(context.getCurrentIteration());
        LOG.info("Start itertion {} with container id {} and app id {}.", new Object[]{context.getCurrentIteration(), context.getContainerId(), context.getAppId()});
    }

    @Override
    public void postIteration(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appMasterNode;
                int currentIteration;
                String appId;
                block7: {
                    appId = context.getAppId();
                    currentIteration = context.getCurrentIteration();
                    String containerId = context.getContainerId();
                    appMasterNode = AsyncWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                    String appWorkerNode = AsyncWorkerCoordinator.this.getCurrentWorkerNode(appId, containerId, currentIteration).toString();
                    String appWorkerSplitNode = AsyncWorkerCoordinator.this.getCurrentWorkerSplitNode(appId, containerId, currentIteration).toString();
                    boolean isSplit = false;
                    try {
                        byte[] bytes = AsyncWorkerCoordinator.this.getWorkerSerializer().objectToBytes(context.getWorkerResult());
                        isSplit = AsyncWorkerCoordinator.this.setBytesToZNode(appWorkerNode, appWorkerSplitNode, bytes, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        LOG.warn("Has such node:{}", (Object)appWorkerNode);
                    }
                    if (context.getCurrentIteration() >= 1) {
                        String znode = AsyncWorkerCoordinator.this.getWorkerNode(appId, containerId, currentIteration - 1).toString();
                        try {
                            AsyncWorkerCoordinator.this.getZooKeeper().deleteExt(znode, -1, false);
                            if (isSplit) {
                                znode = AsyncWorkerCoordinator.this.getCurrentWorkerSplitNode(appId, containerId, currentIteration - 1).toString();
                                AsyncWorkerCoordinator.this.getZooKeeper().deleteExt(znode, -1, true);
                            }
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 20L != 0L) break block7;
                            LOG.warn("No such node:{}", (Object)znode);
                        }
                    }
                }
                LOG.info("wait to check master:{}", (Object)appMasterNode);
                long start = System.nanoTime();
                Stat stat = AsyncWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, true);
                if (stat == null) {
                    AsyncWorkerCoordinator.this.masterIterationLock.waitForever();
                    AsyncWorkerCoordinator.this.masterIterationLock.reset();
                }
                LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                String appMasterSplitNode = AsyncWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                AsyncWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                LOG.info("Master computation is done.");
            }
        }.execute();
    }
}

