/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.genetic;

import org.encog.mathutil.randomize.Randomizer;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.genetic.BasicGeneticAlgorithm;
import org.encog.ml.genetic.crossover.Splice;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.mutate.MutatePerturb;
import org.encog.ml.genetic.population.BasicPopulation;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.genetic.GeneticScoreAdapter;
import org.encog.neural.networks.training.genetic.NeuralGenome;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.logging.EncogLogging;

public class NeuralGeneticAlgorithm
extends BasicTraining
implements MultiThreadable {
    private NeuralGeneticAlgorithmHelper genetic = new NeuralGeneticAlgorithmHelper();

    public NeuralGeneticAlgorithm(BasicNetwork network, Randomizer randomizer, CalculateScore calculateScore, int populationSize, double mutationPercent, double percentToMate) {
        super(TrainingImplementationType.Iterative);
        this.genetic.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        BasicPopulation population = new BasicPopulation(populationSize);
        this.getGenetic().setMutationPercent(mutationPercent);
        this.getGenetic().setMatingPopulation(percentToMate * 2.0);
        this.getGenetic().setPercentToMate(percentToMate);
        this.getGenetic().setCrossover(new Splice(network.getStructure().calculateSize() / 3));
        this.getGenetic().setMutate(new MutatePerturb(4.0));
        this.getGenetic().setPopulation(population);
        for (int i = 0; i < population.getPopulationSize(); ++i) {
            BasicNetwork chromosomeNetwork = (BasicNetwork)network.clone();
            randomizer.randomize(chromosomeNetwork);
            NeuralGenome genome = new NeuralGenome(chromosomeNetwork);
            genome.setGeneticAlgorithm(this.getGenetic());
            this.getGenetic().calculateScore(genome);
            this.getGenetic().getPopulation().add(genome);
        }
        population.sort();
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    public final NeuralGeneticAlgorithmHelper getGenetic() {
        return this.genetic;
    }

    @Override
    public final MLMethod getMethod() {
        return this.getGenetic().getMethod();
    }

    @Override
    public final void iteration() {
        EncogLogging.log(1, "Performing Genetic iteration.");
        this.preIteration();
        this.getGenetic().iteration();
        this.setError(this.getGenetic().getError());
        this.postIteration();
    }

    @Override
    public final TrainingContinuation pause() {
        return null;
    }

    @Override
    public final void resume(TrainingContinuation state) {
    }

    public final void setGenetic(NeuralGeneticAlgorithmHelper genetic) {
        this.genetic = genetic;
    }

    @Override
    public int getThreadCount() {
        return this.genetic.getThreadCount();
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.genetic.setThreadCount(numThreads);
    }

    public class NeuralGeneticAlgorithmHelper
    extends BasicGeneticAlgorithm {
        public final double getError() {
            Genome genome = this.getPopulation().getBest();
            return genome.getScore();
        }

        public final MLMethod getMethod() {
            Genome genome = this.getPopulation().getBest();
            return (BasicNetwork)genome.getOrganism();
        }
    }
}

