/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.quick;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.train.prop.TrainFlatNetworkQPROP;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.EngineArray;
import org.encog.util.validate.ValidateNetwork;

public class QuickPropagation
extends Propagation
implements LearningRate {
    public static final String LAST_GRADIENTS = "LAST_GRADIENTS";

    public QuickPropagation(ContainsFlat network, MLDataSet training) {
        this(network, training, 2.0);
    }

    public QuickPropagation(ContainsFlat network, MLDataSet training, double learnRate) {
        super(network, training);
        ValidateNetwork.validateMethodToData(network, training);
        TrainFlatNetworkQPROP backFlat = new TrainFlatNetworkQPROP(network.getFlat(), this.getTraining(), learnRate);
        this.setFlatTraining(backFlat);
    }

    @Override
    public final boolean canContinue() {
        return false;
    }

    public final double[] getLastDelta() {
        return ((TrainFlatNetworkQPROP)this.getFlatTraining()).getLastDelta();
    }

    @Override
    public final double getLearningRate() {
        return ((TrainFlatNetworkQPROP)this.getFlatTraining()).getLearningRate();
    }

    public final boolean isValidResume(TrainingContinuation state) {
        if (!state.getContents().containsKey(LAST_GRADIENTS)) {
            return false;
        }
        if (!state.getTrainingType().equals(this.getClass().getSimpleName())) {
            return false;
        }
        double[] d = (double[])state.get(LAST_GRADIENTS);
        return d.length == ((ContainsFlat)this.getMethod()).getFlat().getWeights().length;
    }

    @Override
    public final TrainingContinuation pause() {
        TrainingContinuation result = new TrainingContinuation();
        result.setTrainingType(this.getClass().getSimpleName());
        TrainFlatNetworkQPROP qprop = (TrainFlatNetworkQPROP)this.getFlatTraining();
        double[] d = qprop.getLastGradient();
        result.set(LAST_GRADIENTS, d);
        return result;
    }

    @Override
    public final void resume(TrainingContinuation state) {
        if (!this.isValidResume(state)) {
            throw new TrainingError("Invalid training resume data length");
        }
        double[] lastGradient = (double[])state.get(LAST_GRADIENTS);
        EngineArray.arrayCopy(lastGradient, ((TrainFlatNetworkQPROP)this.getFlatTraining()).getLastGradient());
    }

    @Override
    public final void setLearningRate(double rate) {
        ((TrainFlatNetworkQPROP)this.getFlatTraining()).setLearningRate(rate);
    }

    public double getOutputEpsilon() {
        return ((TrainFlatNetworkQPROP)this.getFlatTraining()).getOutputEpsilon();
    }

    public double getShrink() {
        return ((TrainFlatNetworkQPROP)this.getFlatTraining()).getShrink();
    }

    public void setShrink(double shrink) {
        ((TrainFlatNetworkQPROP)this.getFlatTraining()).setShrink(shrink);
    }

    public void setOutputEpsilon(double outputEpsilon) {
        this.setOutputEpsilon(outputEpsilon);
    }
}

