/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.art.ART1;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class ART1Pattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;

    @Override
    public final void addHiddenLayer(int count) {
        throw new PatternError("A ART1 network has no hidden layers.");
    }

    @Override
    public final void clear() {
        this.inputNeurons = 0;
        this.outputNeurons = 0;
    }

    @Override
    public final MLMethod generate() {
        ART1 art = new ART1(this.inputNeurons, this.outputNeurons);
        art.setA1(this.a1);
        art.setB1(this.b1);
        art.setC1(this.c1);
        art.setD1(this.d1);
        art.setL(this.l);
        art.setVigilance(this.vigilance);
        return art;
    }

    public final double getA1() {
        return this.a1;
    }

    public final double getB1() {
        return this.b1;
    }

    public final double getC1() {
        return this.c1;
    }

    public final double getD1() {
        return this.d1;
    }

    public final double getL() {
        return this.l;
    }

    public final double getVigilance() {
        return this.vigilance;
    }

    public final void setA1(double a1) {
        this.a1 = a1;
    }

    @Override
    public final void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("Can't set the activation function for an ART1.");
    }

    public final void setB1(double b1) {
        this.b1 = b1;
    }

    public final void setC1(double c1) {
        this.c1 = c1;
    }

    public final void setD1(double d1) {
        this.d1 = d1;
    }

    @Override
    public final void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    public final void setL(double l) {
        this.l = l;
    }

    @Override
    public final void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public final void setVigilance(double vigilance) {
        this.vigilance = vigilance;
    }
}

