/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.ZooKeeperUtils;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.worker.BasicWorkerInterceptor;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperWorkerInterceptor<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicWorkerInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperWorkerInterceptor.class);
    private static final int WAIT_SLOT_MILLS = 300;
    private long sleepTime = 300L;
    private boolean isFixedTime = true;

    public void preApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        String zkServers = context.getProps().getProperty("guagua.zk.servers");
        if (zkServers == null || zkServers.length() == 0 || !ZooKeeperUtils.checkServers((String)zkServers)) {
            this.sleepTime = NumberFormatUtils.getLong((String)context.getProps().getProperty("guagua.coordinator.sleep.unit"), (long)300L);
            this.isFixedTime = Boolean.TRUE.toString().equalsIgnoreCase(context.getProps().getProperty("guagua.coordinator.fixed.sleep.enable", "true"));
            BufferedReader br = null;
            try {
                final FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
                String hdfsZookeeperServerFolder = this.getZookeeperServerFolder(context);
                final Path zookeeperServerPath = fileSystem.makeQualified(new Path(hdfsZookeeperServerFolder, "zookeeper_server"));
                new BasicCoordinator.RetryCoordinatorCommand(this.isFixedTime, this.sleepTime){

                    public boolean retryExecution() throws Exception, InterruptedException {
                        return fileSystem.exists(zookeeperServerPath);
                    }
                }.execute();
                FSDataInputStream fis = fileSystem.open(zookeeperServerPath);
                br = new BufferedReader(new InputStreamReader((InputStream)fis));
                String zookeeperServer = br.readLine();
                if (zookeeperServer == null || zookeeperServer.length() == 0) {
                    throw new GuaguaRuntimeException("Cannot get zookeeper server in " + zookeeperServerPath.toString());
                }
                LOG.info("Embeded zookeeper instance is {}", (Object)zookeeperServer);
                context.getProps().setProperty("guagua.zk.servers", zookeeperServer);
            }
            catch (IOException e) {
                try {
                    throw new GuaguaRuntimeException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(br);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)br);
        }
    }

    private String getZookeeperServerFolder(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        String defaultZooKeeperServePath = new StringBuilder(200).append("tmp").append("/").append("_guagua").append("/").append(context.getAppId()).append("/").toString();
        String hdfsZookeeperServerPath = context.getProps().getProperty("guagua.zk.cluster.server.folder", defaultZooKeeperServePath);
        return hdfsZookeeperServerPath;
    }
}

