/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.io;

import java.io.IOException;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import ml.shifu.guagua.util.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.SequenceFileRecordReader;

public class GuaguaSequenceRecordReader<KEY extends Writable, VALUE extends Writable>
implements GuaguaRecordReader<GuaguaWritableAdapter<KEY>, GuaguaWritableAdapter<VALUE>> {
    private SequenceFileRecordReader<KEY, VALUE> sequenceReader;
    private Configuration conf;
    private GuaguaWritableAdapter<KEY> key = null;
    private GuaguaWritableAdapter<VALUE> value = null;
    private Class<? extends Writable> keyClass;
    private Class<? extends Writable> valueClass;

    public GuaguaSequenceRecordReader(Class<? extends Writable> keyClass, Class<? extends Writable> valueClass) throws IOException {
        this(null, keyClass, valueClass);
    }

    public GuaguaSequenceRecordReader(GuaguaFileSplit split, Class<? extends Writable> keyClass, Class<? extends Writable> valueClass) throws IOException {
        this(new Configuration(), split, keyClass, valueClass);
    }

    public GuaguaSequenceRecordReader(Configuration conf, GuaguaFileSplit split, Class<? extends Writable> keyClass, Class<? extends Writable> valueClass) throws IOException {
        this.conf = conf;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        if (split != null) {
            this.initialize(split);
        }
    }

    public float getProgress() throws IOException {
        return this.sequenceReader.getProgress();
    }

    public void initialize(GuaguaFileSplit split) throws IOException {
        FileSplit fileSplit = new FileSplit(new Path(split.getPath()), split.getOffset(), split.getLength(), (String[])null);
        this.sequenceReader = new SequenceFileRecordReader(this.conf, fileSplit);
    }

    public boolean nextKeyValue() throws IOException {
        if (this.key == null) {
            this.key = new GuaguaWritableAdapter<Writable>((Writable)ReflectionUtils.newInstance(this.keyClass));
        }
        if (this.value == null) {
            this.value = new GuaguaWritableAdapter<Writable>((Writable)ReflectionUtils.newInstance(this.valueClass));
        }
        return this.sequenceReader.next(this.key.getWritable(), this.value.getWritable());
    }

    public GuaguaWritableAdapter<KEY> getCurrentKey() {
        return this.key;
    }

    public GuaguaWritableAdapter<VALUE> getCurrentValue() {
        return this.value;
    }

    public synchronized void close() throws IOException {
        if (this.sequenceReader != null) {
            this.sequenceReader.close();
        }
    }
}

